<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Values extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Values');
        $this->session->set_userdata('sub_menu', 'values/index');
        $data['title'] = 'Add Values ';
        $data['title_list'] = 'Uniform Value List';

        $this->form_validation->set_rules('values', 'Value Name', 'required');
		$this->form_validation->set_rules('description', 'Value Description', 'required');
		$this->form_validation->set_rules('groups', 'Group Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $values = $this->input->post('values');
            $values_array = array(
                'values' => $this->input->post('values'),
				'description' => $this->input->post('description'),
				'groups' => $this->input->post('groups'),
				'created_at' => date('Y-m-d')
            );
			$this->values_model->add($values_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Values added successfully</div>');
            redirect('values');
        }
		  $data['g']=$this->group_model->select(); 		 
         $data['h']=$this->values_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('values/valuesList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Uniform Values';
        $this->values_model->remove($id);
        redirect('values');
    }

    function edit($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_edit')) {
            access_denied();
        }

        $data['id'] = $id;
		$data['values'] = $this->values_model->update($id);

		 $data['g']=$this->group_model->select(); 		 
         $data['h']=$this->values_model->select(); 		
			
        $this->form_validation->set_rules('values', 'Value Name', 'required');
		$this->form_validation->set_rules('description', 'Value Description', 'required');
		$this->form_validation->set_rules('groups', 'Group Type', 'required');
	   
        if ($this->form_validation->run() == FALSE) {

            $this->load->view('layout/header', $data);
            $this->load->view('values/valuesEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'values' => $this->input->post('values'),
				'description' => $this->input->post('description'),
				'groups' => $this->input->post('groups')
            );
            $this->values_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Group updated successfully</div>');
            redirect('values/index');
        }
    }
}

?>