<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Uniformpos extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Uniform POS');
        $this->session->set_userdata('sub_menu', 'uniformpos/index');
        $data['title'] = 'Make Transactions ';
        $data['title_list'] = 'Uniform Transactions List';

    //(`student_id`, `itemcode`, `description`, `quantity`, `amount`, `payment`, `created_date`)

        $this->form_validation->set_rules('student_id', 'Student Id', 'required');
		$this->form_validation->set_rules('itemcode', 'Item Code', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('quantity', 'Quanity', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required');
		$this->form_validation->set_rules('payment', 'Payment Method', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $student_id = $this->input->post('student_id');
            $itemcode = $this->input->post('itemcode');
            $quantityuser = $this->input->post('quantity');
            $amountpaid = $this->input->post('amount');
            $currency = $this->input->post('payment');

            $this->db->select('*');
            $this->db->from('uniformitem');
            $this->db->where('itemcode', $itemcode);
            $query1 = $this->db->get();
            $result1 = $query1->row();
            $quantity2 = $result1->quantity;
            $sellingprice = $result1->sellingprice;
						
				//CODE FOR GETTING THE HOME AND FOREIGN CURRENCY
				$this->db->select('*');
				$this->db->from('bank_rates');
				$query13 = $this->db->get();
				$result13 = $query13->row();

				$home_currency = $result13->home_currency;
				$foreign_currency = $result13->foreign_currency;
				
			if($currency == 'USD'){
				
						$this->db->select('*');
						$this->db->from('bank_rates');
						$this->db->where('home_currency',$currency);
						$query1 = $this->db->get();
						$row1_rate = $query1->row();
						
						$home_rate = $row1_rate->home_rate;
						
						$converted_amt = $home_rate*$amountpaid;	
						
                    //CALC QNTY LEFT FOR AN ITEM PURCHASED
                    $leftquantity = $quantity2 - $quantityuser;					

					//CALC CUSTOMER CHANGE
					$customer_change = $sellingprice - $converted_amt;				
				
					$uniformpos_array = array(
						'student_id' => $this->input->post('student_id'),
						'itemcode' => $this->input->post('itemcode'),
						'description' => $this->input->post('description'),
						'quantity' => $this->input->post('quantity'),
						'amount' => $amountpaid,
						'payment' => $currency,
						'created_date' => date('Y-m-d'),
						'balance' => $customer_change
					);
					$uniformitem_array = array(
						'itemcode' => $this->input->post('itemcode'),
						'quantity' => $leftquantity
					);				
					$this->uniformpos_model->add($uniformpos_array); 
					$this->uniformitem_model->updateQnty($uniformitem_array);     
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Transaction made successfully</div>');
					redirect('uniformpos');								
			}
			else{

						$this->db->select('*');
						$this->db->from('bank_rates');
						$this->db->where('foreign_currency',$currency);
						$query1 = $this->db->get();
						$row1_rate2 = $query1->row();
						
						$foreign_currency_row1 = $row1_rate2->foreign_currency;
						$foreign_rate = $row1_rate2->foreign_rate;
						
						$converted_amt = ($amountpaid/$foreign_rate)*1;					
				
                   //CALC QNTY LEFT FOR AN ITEM PURCHASED
                    $leftquantity = $quantity2 - $quantityuser;					

					//CALC CUSTOMER CHANGE
					$customer_change = $sellingprice - $converted_amt;				
				
					$uniformpos_array = array(
						'student_id' => $this->input->post('student_id'),
						'itemcode' => $this->input->post('itemcode'),
						'description' => $this->input->post('description'),
						'quantity' => $this->input->post('quantity'),
						'amount' => $amountpaid,
						'payment' => $currency,
						'created_date' => date('Y-m-d'),
						'balance' => $customer_change
					);
					$uniformitem_array = array(
						'itemcode' => $this->input->post('itemcode'),
						'quantity' => $leftquantity
					);				
					$this->uniformpos_model->add($uniformpos_array); 
					$this->uniformitem_model->updateQnty($uniformitem_array);     
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Transaction made successfully</div>');
					redirect('uniformpos');						
			}						

        }
		  $data['payment_methods']=$this->payment_methods_model->select();
		  $data['stud_id']=$this->student_model->select(); 		 
          $data['code']=$this->uniformitem_model->select();
          $data['uniform']=$this->uniformpos_model->select();
          $data['itemlist']=$this->uniformitem_model->select();

        $this->load->view('layout/header', $data);
        $this->load->view('uniformpos/uniformposList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Uniform Transactions';
        $this->group_model->remove($id);
        redirect('uniformpos');
    }

    function edit($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_edit')) {
            access_denied();
        }

        $data['id'] = $id;
		$data['groups'] = $this->group_model->update($id);
		$data['typ']=$this->types_model->select(); 		
			
        $this->form_validation->set_rules('groups', 'Group Name', 'required');
		$this->form_validation->set_rules('group_type', 'Group Type', 'required');
	   
        if ($this->form_validation->run() == FALSE) {
			
		$data['group']=$this->group_model->select(); 
				
            $this->load->view('layout/header', $data);
            $this->load->view('group/groupEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'groups' => $this->input->post('groups'),
				'group_type' => $this->input->post('group_type')
            );
            $this->group_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Group updated successfully</div>');
            redirect('group/index');
        }
    }
}

?>