<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Uniformitem extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Uniform Item');
        $this->session->set_userdata('sub_menu', 'uniformitem/index');
        $data['title'] = 'Add Uniform Item';
        $data['title_list'] = 'Uniform Item';

		$this->form_validation->set_rules('itemcode', 'Item Code', 'required');
		$this->form_validation->set_rules('itemdescript', 'Item Descripiton', 'required');
		$this->form_validation->set_rules('warehouse', 'Warehouse', 'required');
		$this->form_validation->set_rules('costprice', 'Cost Price', 'required');
		$this->form_validation->set_rules('sellingprice', 'Selling Price', 'required');
		$this->form_validation->set_rules('groupsize', 'Group Size', 'required');
		$this->form_validation->set_rules('valuesize', 'Value', 'required');
		$this->form_validation->set_rules('groupstyle', 'Group Style', 'required');
		$this->form_validation->set_rules('stylevalue', 'Value Style', 'required');
		$this->form_validation->set_rules('colourgroup', 'Group Colour', 'required');
		$this->form_validation->set_rules('colourvalue', 'Colour Value', 'required');
		$this->form_validation->set_rules('gendergroup', 'Group Gender', 'required');
		$this->form_validation->set_rules('gendervalue', 'Value', 'required');
		$this->form_validation->set_rules('quantity', 'Quantity', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $itemcode = $this->input->post('itemcode');
			$itemgroup = "none";
            $item_array = array(		
                'itemcode' => $this->input->post('itemcode'),
				'itemdescript' => $this->input->post('itemdescript'),
				'itemgroups' => $itemgroup,
				'warehouse' => $this->input->post('warehouse'),
				'costprice' => $this->input->post('costprice'),
				'sellingprice' => $this->input->post('sellingprice'),
				'quantity' => $this->input->post('quantity'),				
				'originalqnty' => $this->input->post('quantity'),				
				'groupsize' => $this->input->post('groupsize'),				
				'valuesize' => $this->input->post('valuesize'),				
				'groupstyle' => $this->input->post('groupstyle'),				
				'stylevalue' => $this->input->post('stylevalue'),				
				'colourgroup' => $this->input->post('colourgroup'),				
				'colourvalue' => $this->input->post('colourvalue'),				
				'gendergroup' => $this->input->post('gendergroup'),				
				'gendervalue' => $this->input->post('gendervalue'),							
				'created_at' => date('Y-m-d')
            );
			$this->uniformitem_model->add($item_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Item added successfully</div>');
            redirect('uniformitem');
        }
		  $data['g']=$this->group_model->select(); 		 
         $data['v']=$this->values_model->select();  
         $data['typ']=$this->types_model->select();  
         $data['house']=$this->warehouse_model->select();  
         $data['itemlist']=$this->uniformitem_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('uniformitem/uniformitemList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Uniform Item';
        $this->uniformitem_model->remove($id);
        redirect('uniformitem');
    }

         function edit($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_edit')) {
            access_denied();
        }

        $data['id'] = $id;
		$data['uniformitem'] = $this->uniformitem_model->update($id);
		
		  $data['g']=$this->group_model->select(); 		 
         $data['v']=$this->values_model->select();  
         $data['typ']=$this->types_model->select();  
         $data['house']=$this->warehouse_model->select();  
         $data['itemlist']=$this->uniformitem_model->select(); 	
			
		$this->form_validation->set_rules('itemcode', 'Item Code', 'required');
		$this->form_validation->set_rules('itemdescript', 'Item Descripiton', 'required');
		$this->form_validation->set_rules('warehouse', 'Warehouse', 'required');
		$this->form_validation->set_rules('costprice', 'Cost Price', 'required');
		$this->form_validation->set_rules('sellingprice', 'Selling Price', 'required');
		$this->form_validation->set_rules('groupsize', 'Group Size', 'required');
		$this->form_validation->set_rules('valuesize', 'Value', 'required');
		$this->form_validation->set_rules('groupstyle', 'Group Style', 'required');
		$this->form_validation->set_rules('stylevalue', 'Value Style', 'required');
		$this->form_validation->set_rules('colourgroup', 'Group Colour', 'required');
		$this->form_validation->set_rules('colourvalue', 'Colour Value', 'required');
		$this->form_validation->set_rules('gendergroup', 'Group Gender', 'required');
		$this->form_validation->set_rules('gendervalue', 'Value', 'required');
		$this->form_validation->set_rules('quantity', 'Quantity', 'required');
	   
        if ($this->form_validation->run() == FALSE) {

            $this->load->view('layout/header', $data);
            $this->load->view('uniformitem/uniformitemEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'itemcode' => $this->input->post('itemcode'),
				'itemdescript' => $this->input->post('itemdescript'),
				'itemgroups' => $itemgroup,
				'warehouse' => $this->input->post('warehouse'),
				'costprice' => $this->input->post('costprice'),
				'sellingprice' => $this->input->post('sellingprice'),
				'quantity' => $this->input->post('quantity'),				
				'groupsize' => $this->input->post('groupsize'),				
				'valuesize' => $this->input->post('valuesize'),				
				'groupstyle' => $this->input->post('groupstyle'),				
				'stylevalue' => $this->input->post('stylevalue'),				
				'colourgroup' => $this->input->post('colourgroup'),				
				'colourvalue' => $this->input->post('colourvalue'),				
				'gendergroup' => $this->input->post('gendergroup'),				
				'gendervalue' => $this->input->post('gendervalue')		
            );
            $this->uniformitem_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Item updated successfully</div>');
            redirect('uniformitem/index');
        }
    }
}

?>