<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Types extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {

        $this->session->set_userdata('top_menu', 'Types');
        $this->session->set_userdata('sub_menu', 'types/index');
        $data['title'] = 'Add Uniform Types';
        $data['title_list'] = 'Uniform Types';

		$this->form_validation->set_rules('types', 'Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $types = $this->input->post('types');
            $types_array = array(
				'types' => $this->input->post('types'),				
				'created_at' => date('Y-m-d')
            );
			$this->types_model->add($types_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Types added successfully</div>');
            redirect('types');
        }
		  $data['g']=$this->group_model->select(); 		 
         $data['v']=$this->values_model->select();  
         $data['typ']=$this->types_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('types/typeList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {

        $data['title'] = 'Uniform Types';
        $this->types_model->remove($id);
        redirect('types');
    }

    function edit($id) {

        $data['title'] = 'Types List';
        $data['title'] = 'Edit Types';
		
        $data['id'] = $id;
		$data['types'] = $this->types_model->update($id);
		
		$data['typ'] = $this->types_model->select();
		
       $this->form_validation->set_rules('types', 'Type', 'required');
	   
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('types/typeEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'types' => $this->input->post('types'),
            );
            $this->types_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Type updated successfully</div>');
            redirect('types/index');
        }
    }

}

?>