<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Group extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Groups');
        $this->session->set_userdata('sub_menu', 'group/index');
        $data['title'] = 'Add Group ';
        $data['title_list'] = 'Uniform Group List';

        $this->form_validation->set_rules('groups', 'Group Name', 'required');
		$this->form_validation->set_rules('group_type', 'Group Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {
            $group = $this->input->post('groups');
            $group_array = array(
                'groups' => $this->input->post('groups'),
				'group_type' => $this->input->post('group_type'),
				'created_at' => date('Y-m-d')
            );
			$this->group_model->add($group_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Group added successfully</div>');
            redirect('group/index');
        }
		 
         $data['h']=$this->group_model->select(); 
         $data['typ']=$this->types_model->select(); 

        $this->load->view('layout/header', $data);
        $this->load->view('group/groupList', $data);
        $this->load->view('layout/footer', $data);
    }

     function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Uniform Group';
        $this->group_model->remove($id);
        redirect('group');
    }

    function edit($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_edit')) {
            access_denied();
        }

        $data['id'] = $id;
		$data['groups'] = $this->group_model->update($id);
		$data['typ']=$this->types_model->select(); 		
			
        $this->form_validation->set_rules('groups', 'Group Name', 'required');
		$this->form_validation->set_rules('group_type', 'Group Type', 'required');
	   
        if ($this->form_validation->run() == FALSE) {
			
		$data['group']=$this->group_model->select(); 
				
            $this->load->view('layout/header', $data);
            $this->load->view('group/groupEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'groups' => $this->input->post('groups'),
				'group_type' => $this->input->post('group_type')
            );
            $this->group_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Uniform Group updated successfully</div>');
            redirect('group/index');
        }
    }

}

?>