<?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">

    <section class="content-header">
        <h1>
            <i class="fa fa-mortar-board"></i> Journal Processing </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <?php
            if ($this->rbac->hasPrivilege('class', 'can_add')) {
                ?>  
                <div class="col-md-4">
                    <!-- Horizontal Form -->
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo $title;       ?></h3>
								 <a href="<?php  echo base_url(); ?>journal_accounts" class="col-md pull-right">Add Journal Account</a>
                        </div><!-- /.box-header -->
                        <form id="form1" action="<?php echo base_url() ?>jornal"  method="POST" accept-charset="utf-8">
                            <div class="box-body">
                                <?php if ($this->session->flashdata('msg')) { ?>
                                    <?php echo $this->session->flashdata('msg') ?>
                                <?php } ?>
                                <?php
                                if (isset($error_message)) {
                                    echo "<div class='alert alert-danger'>" . $error_message . "</div>";
                                }    
                                ?>
                                <?php echo $this->customlib->getCSRF(); ?>                                																
                               	<div class="form-group">
                                    <label for="colour">Date</label><small class="req"> *</small>
                                    <input autofocus="" id="date" name="date" placeholder="" type="date" class="form-control"  value="<?php echo set_value('date'); ?>" />
                                    <span class="text-danger"><?php echo form_error('date'); ?></span>
                                </div>								
                                <div class="form-group">
                                    <label for="cashbook">Journal Account</label><small class="req"> *</small>
										<select id="cashbook" name="cashbook" placeholder="" type="text" class="form-control" >
											<option value="select"><?php echo $this->lang->line('select') ?></option>
											<?php 
												foreach ($journal_accounts->result() as $grup) {
												?>
									                <option value="<?php echo $grup->journal_accounts; ?>" >  <?php echo $grup->journal_accounts; ?></option>
											<?php }
											?>
										</select>
                                    <span class="text-danger"><?php echo form_error('cashbook'); ?></span>
                                </div> 	                               
								<div class="form-group">
                                    <label for="module">Module Name</label><small class="req"> *</small>
										<select id="class_id" name="module" placeholder="" type="text" class="form-control" >
											<option value="select"><?php echo $this->lang->line('select') ?></option>
											<option>Learner</option>
											<option>Supplier</option>
											<option>Customer</option>
											<option>GL</option>
										</select>
                                    <span class="text-danger"><?php echo form_error('module'); ?></span>
                                </div> 	
								<div class="form-group">
                                    <label for="colour">Account Name</label><small class="req"> *</small>
									<select  id="section_id" name="account" class="form-control" >
										<option value=""><?php echo $this->lang->line('select'); ?></option>
									</select>									
                                    <span class="text-danger"><?php echo form_error('account'); ?></span>
                                </div>						
								<div class="form-group">
                                    <label for="colour">Reference</label><small class="req"> *</small>
                                    <input autofocus="" id="receipt" name="receipt" placeholder="" type="text" class="form-control"  value="<?php echo set_value('receipt'); ?>" />
                                    <span class="text-danger"><?php echo form_error('receipt'); ?></span>
                                </div>									
								<div class="form-group">
                                    <label for="currency">TR Code</label><small class="req"> *</small>
										<select id="dr_cr" name="dr_cr" placeholder="" type="text" class="form-control" >
											<option value="select"><?php echo $this->lang->line('select') ?></option>
											<option value="dr" > Debit</option>
											<option value="cr" > Credit</option>
										</select>
                                    <span class="text-danger"><?php echo form_error('dr_cr'); ?></span>
                                </div> 								
								<div class="form-group">
                                    <label for="colour">Description</label><small class="req"> *</small>
                                    <input autofocus="" id="description" name="description" placeholder="" type="text" class="form-control"  value="<?php echo set_value('description'); ?>" />
                                    <span class="text-danger"><?php echo form_error('description'); ?></span>
                                </div>	
								<div class="form-group">
                                    <label for="amount">Amount</label><small class="req"> *</small>
                                    <input autofocus="" id="amount" name="amount" placeholder="" type="text" class="form-control"  value="<?php echo set_value('amount'); ?>" />
                                    <span class="text-danger"><?php echo form_error('amount'); ?></span>
                                </div>								
                            </div><!-- /.box-body -->
                            <div class="box-footer">
                                <button type="submit" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                            </div>
                        </form>
                    </div>
                </div><!--/.col (right) -->
                <!-- left column -->
            <?php } ?>
            <div class="col-md-<?php
            if ($this->rbac->hasPrivilege('class', 'can_add')) {
                echo "8";
            } else {
                echo "12";
            }
            ?>">
                <!-- general form elements -->
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix"><?php echo $title_list; ?> Transactions</h3>
                        <div class="box-tools pull-right">
						<a href="<?php  echo base_url(); ?>journal_accounts" class="col-md pull-right">Add Journal Account</a>
                        </div><!-- /.box-tools -->
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive mailbox-messages">
                            <div class="download_label"><?php echo $title_list; ?></div>
                            <table class="table table-striped table-bordered table-hover example">
                                <thead>
                                    <tr>
                                        <th>Date Captured</th>
                                        <th>Journal</th>
                                        <th>Module</th>
                                        <th>Account</th>
                                        <th>Description</th>
                                        <th>Reference (Receipt)</th>
                                        <th>Currency</th>
                                        <th>Debit</th>
                                        <th>Credit</th>
                                       
                                       
                                    </tr>
                                </thead>
                                <tbody>
                                <?php  
																
										 foreach ($jornal->result() as $row)  
										 {   
                                        ?>
                                        <tr>
                                            <td class="mailbox-name"><?php echo $row->date;?></td>
                                            <td class="mailbox-name"><?php echo $row->cashbook;?></td>
                                            <td class="mailbox-name"><?php echo $row->module;?></td>
                                            <td class="mailbox-name"><?php echo $row->account;?></td>
                                            <td class="mailbox-name"><?php echo $row->description;?></td>
                                            <td class="mailbox-name"><?php echo $row->receipt;?></td>
                                            <td class="mailbox-name"><?php 
											
                                                $journal_accounts= $row->cashbook;

                                                $this->db->select('*');
                                                $this->db->from('journal_accounts');
                                                $this->db->where('journal_accounts', $journal_accounts);
                                                $query = $this->db->get();
                                                $result = $query->row();
												
												echo $result->currency;
											?></td>
                                            <td class="mailbox-name"><?php echo $row->debit;?></td>
                                            <td class="mailbox-name"><?php echo $row->credit;?></td>                                       
                                        </tr>
									<?php } ?>
                                </tbody>
                            </table><!-- /.table -->



                        </div><!-- /.mail-box-messages -->
                    </div><!-- /.box-body -->
                </div>
            </div><!--/.col (left) -->
            <!-- right column -->

        </div>
        <div class="row">
            <!-- left column -->

            <!-- right column -->
            <div class="col-md-12">

            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->
<script type="text/javascript">
    function getSectionByClass(class_id, section_id) {
        if (class_id != "" && section_id != "") {
            $('#section_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "cashbook/getByModule",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
						if( class_id == 'Learner'){
							div_data += "<option value=" +obj.firstname +" "+ obj.lastname + ">" +obj.firstname +" "+ obj.lastname + "</option>";
						}
						else if( class_id == 'Supplier'){
							div_data += "<option value=" + obj.name + ">" + obj.name + "</option>";
						}							
						else if( class_id == 'GL'){
							if(class_id == 'GL'){
								div_data += "<option value=" + obj.glname + ">" + obj.gl_code +" > "+ obj.glname + "</option>";
							}							
							if(class_id == 'GL'){
								div_data += "<option value=" + obj.subname + ">" + obj.gl_code +" > "+ obj.glsub_code +" > "+ obj.subname + "</option>";
							}
							
						}							
						else if( class_id == 'Customer'){
							div_data += "<option value=" + obj.name + ">" + obj.name + "</option>";
						}
						else{
							div_data += "<option value=" + obj.name + " " + sel + ">" + obj.name + "</option>";
						}
                    });
                    $('#section_id').append(div_data);
                }
            });
        }
    }

    $(document).ready(function () {
        var class_id = $('#class_id').val();
        var section_id = '<?php echo set_value('section_id') ?>';
        getSectionByClass(class_id, section_id);
        $(document).on('change', '#class_id', function (e) {
            $('#section_id').html("");
            var class_id = $(this).val();
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "cashbook/getByModule",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
						if( class_id == 'Learner'){
							div_data += "<option value=" +obj.firstname +" "+ obj.lastname + ">" +obj.firstname +" "+ obj.lastname + "</option>";
						}
						else if( class_id == 'Supplier'){
							div_data += "<option value=" + obj.name + ">" + obj.name + "</option>";
						}							
						else if( class_id == 'GL'){
							if(class_id == 'GL'){
								div_data += "<option value=" + obj.glname + ">" + obj.gl_code +" > "+ obj.glname + "</option>";
							}							
							if(class_id == 'GL'){
								div_data += "<option value=" + obj.subname + ">" + obj.gl_code +" > "+ obj.glsub_code +" > "+ obj.subname + "</option>";
							}
							
						}					
						else if( class_id == 'Customer'){
							div_data += "<option value=" + obj.name + ">" + obj.name + "</option>";
						}
						else{
							div_data += "<option value=" + obj.name +">" + obj.name + "</option>";
						}
                        
                    });
                    $('#section_id').append(div_data);
                }
            });
        });
    });
</script>