<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bankrec_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */
    public function get($id = null) {

        $userdata = $this->customlib->getUserData();
        $role_id = $userdata["role_id"];
        $carray = array();

            $this->db->select()->from('bankrec');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
            if ($id != null) {
                $grouplist = $query->row_array();
            } else {
                $grouplist = $query->result_array();
            }
            // echo $this->db->last_query();
            // exit();
        return $grouplist;
    }

      //we will use the updating INFO FO
      public function update($id)  
      {  
            $this->db->select()->from('bankrec');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
			
         return $query;  
      }

      public function select()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('bankrec');  
         return $query;  
      }  
	  
	  public function select_where_cleared($cashbook, $from, $to)  
      {  
         //data is retrive from this query   2023-01-17
		$active = 1;
		$this->db->select('*');
		$this->db->from('bankrec');
		$this->db->where('active =', $active);
		$this->db->where('cashbook =',  $cashbook);
		$this->db->where('date_captured >= ', $from);
		$this->db->where('date_captured <= ', $to);
		$query = $this->db->get();
		
         return $query;  
      } 
  
    public function update_cashbook_table($data){
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('cashbook', $data);
        } else {
            $this->db->insert('cashbook', $data);
        }
    } 
	  
	  public function select_report()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('bankrec');  
         return $query;  
      }
    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id) {
        $this->db->trans_begin();
        $this->db->where('id', $id);
        $this->db->delete('bankrec'); //class record delete.

       // $this->db->where('group_id', $id);
       // $this->db->delete('uniform_group'); //class_sections record delete.

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return TRUE;
    }

    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('bankrec', $data);
        } else {
            $this->db->insert('bankrec', $data);
        }
    }   

    function check_data_exists($data) {
        $this->db->where('bankrec', $data);

        $query = $this->db->get('bankrec');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }

    public function class_exists($str) {

        $class = $this->security->xss_clean($str);
        $res = $this->check_data_exists($class);

        if ($res) {
            $pre_class_id = $this->input->post('pre_class_id');
            if (isset($pre_class_id)) {
                if ($res->id == $pre_class_id) {
                    return TRUE;
                }
            }
            $this->form_validation->set_message('class_exists', 'Record already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }

// CODE FOR SEARCHING BY DATE
//01 -  - CBZ-USD - date - 200
 public function bankrec_search_by_date($cashbook_account, $find) {
	// $cashboook= 'CBZ-ZWL';
	// $from= '2022-11-22';
	// $to= '10-11-2022';
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('cashbook = ',  $cashbook_account);
		$this->db->where('date = ', $find);
		$query = $this->db->get();

        return $query;
    }
	
	// CODE FOR SEARCHING BY REFERENCE

 public function bankrec_search_by_reference($cashbook_account, $period, $find) {
	 
		$query = "
		SELECT `id`,`date`,`cashbook`, `description`, `account`, `module`, `receipt`, `currency`, `debit`, `credit`, `bankrec`, 
        MONTH (date) AS month
        FROM cashbook
		WHERE cashbook = '$cashbook_account' and receipt = '$find' and MONTH(date) = '$period'";
		
		$query = $this->db->query($query);
				
		return $query;									
    }	
	
	// CODE FOR SEARCHING BY PAYMENTS

 public function bankrec_search_by_payments($cashbook_account, $period, $find) {
	 
		$this->db->select('`id`,`date`,`cashbook`, `description`, `account`, `module`, `receipt`, `currency`, `debit`, `credit`, `bankrec`, MONTH (date) AS month');
		$this->db->from('cashbook');
		$this->db->where('cashbook = ',  $cashbook_account);
		$this->db->where('credit = ',  $find);
		$query = $this->db->get();		
		//$query = $this->db->query($query);
		
		return $query;
    } 	
	
	// CODE FOR VIEWING ALL DETAILS

 public function bankrec_view_all($cashbook_account, $period) {

//NOTE IF IS A YEAR WE SAY  WHERE YEAR(date) = '$period_year'
		$query = "
		SELECT `id`,`date`,`cashbook`, `description`, `account`, `module`, `receipt`, `currency`, `debit`, `credit`, `bankrec`, 
        MONTH (date) AS month
        FROM cashbook
		WHERE cashbook = '$cashbook_account' and MONTH(date) = '$period' ";
		
		$query = $this->db->query($query);

        return $query;
    } 
	
	// CODE FOR SEARCHING BY PAYMENTS
	
	public function bankrec_search_by_deposits($cashbook_account, $period, $find) {
	 
		$query = "
		SELECT `id`,`date`,`cashbook`, `description`, `account`, `module`, `receipt`, `currency`, `debit`, `credit`, `bankrec`, 
        MONTH (date) AS month
        FROM cashbook
		WHERE cashbook = '$cashbook_account' and debit = '$find' and MONTH(date) = '$period'";
		
		$query = $this->db->query($query);
		return $query;
    }
	
	
}
