<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Uniformitem_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */
    public function get($id = null) {

        $userdata = $this->customlib->getUserData();
        $role_id = $userdata["role_id"];
        $carray = array();

            $this->db->select()->from('uniformitem');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
            if ($id != null) {
                $grouplist = $query->row_array();
            } else {
                $grouplist = $query->result_array();
            }
            // echo $this->db->last_query();
            // exit();
        return $grouplist;
    }
      //we will use the updating INFO FO
      public function update($id)  
      {  
            $this->db->select()->from('uniformitem');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
			
         return $query;  
      }

      //we will use the select function  
      public function select()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('uniformitem');  
         return $query;  
      }
	  
    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id) {
        $this->db->trans_begin();
        $this->db->where('id', $id);
        $this->db->delete('uniformitem'); //class record delete.

       // $this->db->where('group_id', $id);
       // $this->db->delete('uniform_group'); //class_sections record delete.

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return TRUE;
    }
    public function updateQnty($quantity){
        $this->db->where('itemcode', $quantity['itemcode']);
        $this->db->update('uniformitem', $quantity);

    }
    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('uniformitem', $data);
        } else {
            $this->db->insert('uniformitem', $data);
        }
    }

    function check_data_exists($data) {
        $this->db->where('groups', $data);

        $query = $this->db->get('uniformitem');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }

    public function class_exists($str) {

        $class = $this->security->xss_clean($str);
        $res = $this->check_data_exists($class);

        if ($res) {
            $pre_class_id = $this->input->post('pre_class_id');
            if (isset($pre_class_id)) {
                if ($res->id == $pre_class_id) {
                    return TRUE;
                }
            }
            $this->form_validation->set_message('class_exists', 'Record already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }
	
	public function getUniformQntyNumber() {
		
$this->db->select_sum('originalqnty');
$result = $this->db->get('uniformitem')->row();  
return $result->originalqnty;
 
    }		
	public function getUniformQntySoldNumber() {
		
$this->db->select_sum('quantity');
$result = $this->db->get('uniformpos')->row();  
return $result->quantity;		

    }	
	public function getUniformQntyLeftNumber() {
		
$this->db->select_sum('originalqnty');
$result = $this->db->get('uniformitem')->row();  
$calc_qnty = $result->originalqnty;		

$this->db->select_sum('quantity');
$result2 = $this->db->get('uniformpos')->row();  
$qnty_sold = $result2->quantity;	
		
		 $qnty_on_hand = $calc_qnty - $qnty_sold;

        return $qnty_on_hand;
    }
}
