<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplier_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */

      //we will use the updating INFO FO
      public function update($id)  
      {  
            $this->db->select()->from('supplier');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
			
         return $query;  
      }

      public function select()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('supplier');  
         return $query;  
      }      
	  
	  public function select_supplier_invoice()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('supplier_invoice');  
         return $query;  
      }	 

	  public function select_supplier_receipt()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('supplier_receipt');  
         return $query;  
      }	  
	  
	  public function select_supplier_statement()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('supplier_statement');  
         return $query;  
      }
    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id) {
        $this->db->trans_begin();
        $this->db->where('id', $id);
        $this->db->delete('supplier'); //class record delete.

       // $this->db->where('group_id', $id);
       // $this->db->delete('uniform_group'); //class_sections record delete.

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return TRUE;
    }

    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('supplier', $data);
        } else {
            $this->db->insert('supplier', $data);
        }
    }   

	public function add_supplier_invoice($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('supplier_invoice', $data);
        } else {
            $this->db->insert('supplier_invoice', $data);
        }
    }	
	public function add_to_statement($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('supplier_statement', $data);
        } else {
            $this->db->insert('supplier_statement', $data);
        }
    }	
	
	public function add_supplier_receipt($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('supplier_receipt', $data);
        } else {
            $this->db->insert('supplier_receipt', $data);
        }
    }

    function check_data_exists($data) {
        $this->db->where('groups', $data);

        $query = $this->db->get('uniform_group');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }

    public function class_exists($str) {

        $class = $this->security->xss_clean($str);
        $res = $this->check_data_exists($class);

        if ($res) {
            $pre_class_id = $this->input->post('pre_class_id');
            if (isset($pre_class_id)) {
                if ($res->id == $pre_class_id) {
                    return TRUE;
                }
            }
            $this->form_validation->set_message('class_exists', 'Record already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }
	public function supplier_search($name, $from, $to) {
   
		$this->db->select('*');
		$this->db->from('supplier_statement');
		$this->db->where('supplier = ',  $name);
		$this->db->where('date >= ', $from);
		$this->db->where('date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	
	
	public function supplier_expenses_search($gl_account, $from, $to) {
   
		$this->db->select('*');
		$this->db->from('supplier_invoice');
		$this->db->where('gl_account = ',  $gl_account);
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	 	
	
	public function supplier_expenses_TO_FROM($from, $to) {
   
		$this->db->select('*');
		$this->db->from('supplier_invoice');
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	
	
	public function supplier_expenses_history_search($gl_account, $from, $to) {
   
		$this->db->select('*');
		$this->db->from('supplier_invoice');
		$this->db->where('gl_account = ',  $gl_account);
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }		
	
	public function mv_expense_history_search($mv_expense, $from, $to) {
   
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('mv_expense = ',  $mv_expense);
		$this->db->where('date >= ', $from);
		$this->db->where('date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	 	
	
	public function mv_expense_history_TO_FROM($from, $to) {
   
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('date >= ', $from);
		$this->db->where('date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	 
		public function supplier_expenses_history_TO_FROM($from, $to) {
   
		$this->db->select('*');
		$this->db->from('supplier_invoice');
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	
	public function mv_expense_report_search($mv_expense, $from, $to) {
   
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('mv_expense = ',  $mv_expense);
		$this->db->where('date >= ', $from);
		$this->db->where('date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	 	
	
	public function mv_expense_report_TO_FROM($from, $to) {
   
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('date >= ', $from);
		$this->db->where('date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	
	
}
