<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Customer_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */

      //we will use the updating INFO FO
      public function update($id)  
      {  
            $this->db->select()->from('customer');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
			
         return $query;  
      }

      public function select()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('customer');  
         return $query;  
      }      
	  
	  public function select_customer_invoice()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('customer_invoice');  
         return $query;  
      }	 

	  public function select_customer_receipt()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('customer_receipt');  
         return $query;  
      }	  
	  
	  public function select_customer_statement()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('customer_statement');  
         return $query;  
      }
    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id) {
        $this->db->trans_begin();
        $this->db->where('id', $id);
        $this->db->delete('customer'); //class record delete.

       // $this->db->where('group_id', $id);
       // $this->db->delete('uniform_group'); //class_sections record delete.

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return TRUE;
    }

    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('customer', $data);
        } else {
            $this->db->insert('customer', $data);
        }
    }   

	public function add_customer_invoice($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('customer_invoice', $data);
        } else {
            $this->db->insert('customer_invoice', $data);
        }
    }	
	public function add_to_statement($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('customer_statement', $data);
        } else {
            $this->db->insert('customer_statement', $data);
        }
    }	
	
	public function add_customer_receipt($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('customer_receipt', $data);
        } else {
            $this->db->insert('customer_receipt', $data);
        }
    }

    public function class_exists($str) {

        $class = $this->security->xss_clean($str);
        $res = $this->check_data_exists($class);

        if ($res) {
            $pre_class_id = $this->input->post('pre_class_id');
            if (isset($pre_class_id)) {
                if ($res->id == $pre_class_id) {
                    return TRUE;
                }
            }
            $this->form_validation->set_message('class_exists', 'Record already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }
	public function customer_search($name, $from, $to) {

		$this->db->select('*');
		$this->db->from('customer_statement');
		$this->db->where('customer = ',  $name);
		$this->db->where('date >= ', $from);
		$this->db->where('date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }
	public function customer_income_search($gl_account, $from, $to) {
   
		$this->db->select('*');
		$this->db->from('customer_invoice');
		$this->db->where('gl_account = ',  $gl_account);
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	 	
	
	public function customer_income_TO_FROM($from, $to) {
   
		$this->db->select('*');
		$this->db->from('customer_invoice');
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	
	
	public function customer_income_history_search($gl_account, $from, $to) {
   
		$this->db->select('*');
		$this->db->from('customer_invoice');
		$this->db->where('gl_account = ',  $gl_account);
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	 	
	
	public function customer_income_history_TO_FROM($from, $to) {
   
		$this->db->select('*');
		$this->db->from('customer_invoice');
		$this->db->where('inv_date >= ', $from);
		$this->db->where('inv_date <= ', $to);
		$query = $this->db->get();
			
        return $query;
    }	
	
}
