<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cashbook_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */
    public function get($id = null) {

        $userdata = $this->customlib->getUserData();
        $role_id = $userdata["role_id"];
        $carray = array();

            $this->db->select()->from('cashbook');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
            if ($id != null) {
                $grouplist = $query->row_array();
            } else {
                $grouplist = $query->result_array();
            }
            // echo $this->db->last_query();
            // exit();
        return $grouplist;
    }

      //we will use the updating INFO FO
      public function update($id)  
      {  
            $this->db->select()->from('cashbook');
            if ($id != null) {
                $this->db->where('id', $id);
            } else {
                $this->db->order_by('id');
            }
            $query = $this->db->get();
			
         return $query;  
      }

      public function select()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('cashbook');  
         return $query;  
      }     

	  public function select_vehicle()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('vehicles');  
         return $query;  
      }      
	  
	  public function select_report()  
      {  
         //data is retrive from this query  
         $query = $this->db->get('cashbook_report');  
         return $query;  
      }
	  public function select_where_not_cleared()  
      {  
         //data is retrive from this query  
		$active = 0;
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('bankrec', $active);
		$query = $this->db->get();
		
         return $query;  
      } 	 

	  public function select_where_cleared()  
      {  
         //data is retrive from this query  
		$active = 1;
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('bankrec', $active);
		$query = $this->db->get();
		
         return $query;  
      } 	  
    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id) {
        $this->db->trans_begin();
        $this->db->where('id', $id);
        $this->db->delete('cashbook'); //class record delete.

       // $this->db->where('group_id', $id);
       // $this->db->delete('uniform_group'); //class_sections record delete.

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return TRUE;
    }

    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('cashbook', $data);
        } else {
            $this->db->insert('cashbook', $data);
        }
    }   

    function check_data_exists($data) {
        $this->db->where('cashbook', $data);

        $query = $this->db->get('cashbook');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }

    public function class_exists($str) {

        $class = $this->security->xss_clean($str);
        $res = $this->check_data_exists($class);

        if ($res) {
            $pre_class_id = $this->input->post('pre_class_id');
            if (isset($pre_class_id)) {
                if ($res->id == $pre_class_id) {
                    return TRUE;
                }
            }
            $this->form_validation->set_message('class_exists', 'Record already exists');
            return FALSE;
        } else {
            return TRUE;
        }
    }


// CODE FOR SEARCHING DATES BETWEEN IN CASH BOOK

 public function cashbook_search($cashbook, $from, $to) {
	// $cashboook= 'CBZ-ZWL';
	// $from= '2022-11-07';
	// $to= '10-11-2022';
		$this->db->select('*');
		$this->db->from('cashbook');
		$this->db->where('cashbook = ',  $cashbook);
		$this->db->where('date_captured >= ', $from);
		$this->db->where('date_captured <= ', $to);
		$query = $this->db->get();
		
		
        return $query;
    }
    public function getSupplierByModule() {
        $this->db->select('supplier.id,supplier.name');
        $this->db->from('supplier');
        $this->db->order_by('supplier.id');
        $query = $this->db->get();
        return $query->result_array();
    }    
	
	public function getCustomerByModule() {
        $this->db->select('customer.id,customer.name');
        $this->db->from('customer');
        $this->db->order_by('customer.id');
        $query = $this->db->get();
        return $query->result_array();
    }	
	
	public function getGLByModule() {

        //$this->db->select('glledger_account.gl_code,glledger_account.name'); $this->db->from('glledger_account');$this->db->order_by('glledger_account.gl_code');$query = $this->db->get();
       $query = "SELECT glledger_account.gl_code,glledger_account.name as glname,glsub_account.glsub_code,glledger_account.account_type,  
					glsub_account.name as subname,glsub_account.account_type,glsub_account.description    
		FROM glledger_account
			JOIN  glaccount_types ON glledger_account.account_type=glaccount_types.name  
			JOIN glsub_account ON glsub_account.account_type=glledger_account.gl_code 
				ORDER BY glledger_account.gL_code ASC";
				
		$query1 = $this->db->query($query);	        
		
		return $query1->result_array();
    }		
	
	public function getLearnereByModule() {
        $this->db->select('students.id,students.firstname,students.lastname');
        $this->db->from('students');
        $this->db->order_by('students.id');
        $query = $this->db->get();
        return $query->result_array();
    }	
	
}
