<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Teams extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Teams');
        $this->session->set_userdata('sub_menu', 'teams/index');
        $data['title'] = 'Add Teams';
        $data['title_list'] = 'Teams';

		$this->form_validation->set_rules('team_name', 'Teams Name', 'required');
		$this->form_validation->set_rules('coachname', 'Coach Name', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');

        if ($this->form_validation->run() == FALSE) {
            
        } else {			

            $active = 1;
            $sportcode = "yes";
            $deprt_array = array(
				'date_captured' => date('Y-m-d h:i:sa'),
				'team_name' => $this->input->post('team_name'),				
				'sportcode' => $sportcode,				
				'coachname' => $this->input->post('coachname'),								
				'description' => $this->input->post('description'),							
				'active' => 1				
            );
			$this->teams_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Teams added successfully</div>');
            redirect('teams');
        }  
		$data['teams']=$this->teams_model->select();  
         $data['sport']=$this->sport_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('teams/teamsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->departments_model->remove($id);
        redirect('teams');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Teams');
        $this->session->set_userdata('sub_menu', 'teams/index');
		
        $data['teams']=$this->teams_model->select(); 
        $data['title'] = 'Edit Teams';
        $data['id'] = $id;

        $data['teams'] = $this->teams_model->update($id);
		
		$data['teams']=$this->teams_model->select();  
         $data['sport']=$this->sport_model->select();  
				
		$this->form_validation->set_rules('team_name', 'Teams Name', 'required');
		$this->form_validation->set_rules('coachname', 'Coach Name', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('teams/teamsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
				'team_name' => $this->input->post('team_name'),						
				'coachname' => $this->input->post('coachname'),							
				'description' => $this->input->post('description'),	
            );
            $this->teams_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Teams updated  successfully</div>');
            redirect('teams/index');
        }
    }

}

?>