<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sport extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Sport');
        $this->session->set_userdata('sub_menu', 'sport/index');
        $data['title'] = 'Add Sport';
        $data['title_list'] = 'Sport';

		$this->form_validation->set_rules('sportcode', 'Sport Code', 'required');
		$this->form_validation->set_rules('name', 'Sport Type', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');
		$this->form_validation->set_rules('age_group', 'Age Group', 'required');
		$this->form_validation->set_rules('team', 'Team Name', 'required');

        if ($this->form_validation->run() == FALSE) {
            
        } else {			

            $active = 1;
            $deprt_array = array(
				'date_captured' => date('Y-m-d h:i:sa'),
				'sportcode' => $this->input->post('sportcode'),				
				'name' => $this->input->post('name'),				
				'description' => $this->input->post('description'),								
				'gender' => $this->input->post('gender'),				
				'age_group' => $this->input->post('age_group'),				
				'team' => $this->input->post('team'),				
				'active' => 1				
            );
			$this->sport_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Sport added successfully</div>');
            redirect('sport');
        }  
		$data['sports']=$this->sport_model->select();  
         $data['age_group']=$this->categories_model->select();  
         $data['sport']=$this->categories_model->select(); 
		  $data['team']=$this->teams_model->select(); 

        $this->load->view('layout/header', $data);
        $this->load->view('sport/sportList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->departments_model->remove($id);
        redirect('sport');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Sport');
        $this->session->set_userdata('sub_menu', 'sport/index');
		
        $data['sport']=$this->sport_model->select(); 
        $data['title'] = 'Edit Sport';
        $data['id'] = $id;

        $data['sport'] = $this->sport_model->update($id);
		
		$data['sports']=$this->sport_model->select();  
         $data['age_group']=$this->categories_model->select();  
         $data['sport']=$this->categories_model->select(); 
         $data['team']=$this->teams_model->select(); 
				
		$this->form_validation->set_rules('sportcode', 'Sport Code', 'required');
		$this->form_validation->set_rules('name', 'Sport Type', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');
		$this->form_validation->set_rules('age_group', 'Age Group', 'required');
		$this->form_validation->set_rules('team', 'Team Name', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('sport/sportEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
				'sportcode' => $this->input->post('sportcode'),				
				'name' => $this->input->post('name'),				
				'description' => $this->input->post('description'),								
				'gender' => $this->input->post('gender'),				
				'age_group' => $this->input->post('age_group'),				
				'team' => $this->input->post('team'),		
            );
            $this->sport_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Sport updated  successfully</div>');
            redirect('sport/index');
        }
    }
	
	   function student_sport() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Sport');
        $this->session->set_userdata('sub_menu', 'sport/index');

		$this->form_validation->set_rules('sportcode', 'Sport Code', 'required');

        if ($this->form_validation->run() == FALSE) {
			
				$this->session->set_userdata('top_menu', 'Team Member');
				$this->session->set_userdata('sub_menu', 'teammember/index');
				
				$data['title'] = 'Team Member';
				
				$class = $this->class_model->get();
				$data['classlist'] = $class;
				
				$this->load->view('layout/header', $data);
				$this->load->view('teammember/teammemberSearch', $data);
				$this->load->view('layout/footer', $data);
				
        } else {			
		
			$active = 1;
            $deprt_array = array(
				'date_captured' => date('Y-m-d h:i:sa'),
				'sportcode' => $this->input->post('sportcode'),				
				'student_id' => $this->input->post('student_id'),
				'active' => $active					
            );
			$this->sport_model->add_student_sport($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Student Sport added successfully</div>');
            redirect('teammember');
        }  
    }

}

?>