<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class School_type extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'School Type');
        $this->session->set_userdata('sub_menu', 'school_type/index');
        $data['title'] = 'Add School Type';
        $data['title_list'] = 'School Type';

		$this->form_validation->set_rules('school_type', 'School Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			

            $active = 1;
            $deprt_array = array(
				'school_type' => $this->input->post('school_type'),					
				'active' => 1				
            );
			$this->school_type_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">School Type added successfully</div>');
            redirect('school_type');
        }  
         $data['school_type']=$this->school_type_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('school_type/school_typeList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'School Type';
        $this->school_type_model->remove($id);
        redirect('school_type');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'School Type');
        $this->session->set_userdata('sub_menu', 'school_type/index');
		
        $data['school_type']=$this->school_type_model->select(); 
        $data['title'] = 'Edit School Type';
        $data['id'] = $id;

        $data['school_type'] = $this->school_type_model->update($id);
				
		$this->form_validation->set_rules('school_type', 'School Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('school_type/school_typeEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'school_type' => $this->input->post('school_type'),
            );
            $this->school_type_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">School Type updated  successfully</div>');
            redirect('school_type/index');
        }
    }

}

?>