<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class School_group extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'School Group');
        $this->session->set_userdata('sub_menu', 'school_group/index');
        $data['title'] = 'Add School Group';
        $data['title_list'] = 'School Group';

		$this->form_validation->set_rules('school_group', 'School Group', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
            $active = 1;
            $deprt_array = array(
				'school_group' => $this->input->post('school_group'),				
				'active' => 1				
            );
			$this->school_group_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">School Group added successfully</div>');
            redirect('school_group');
        }  
         $data['school_group']=$this->school_group_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('school_group/school_groupList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'School Group';
        $this->school_group_model->remove($id);
        redirect('school_group');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'School Group');
        $this->session->set_userdata('sub_menu', 'school_group/index');
		
        $data['school_group']=$this->school_group_model->select(); 
        $data['title'] = 'Edit School Group';
        $data['id'] = $id;

        $data['school_group'] = $this->school_group_model->update($id);
				
		$this->form_validation->set_rules('school_group', 'School Group', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('school_group/school_groupEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'school_group' => $this->input->post('school_group'),
            );
            $this->school_group_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">School Group updated  successfully</div>');
            redirect('school_group/index');
        }
    }

}

?>