<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class School_details extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'School Details');
        $this->session->set_userdata('sub_menu', 'school_details/index');
        $data['title'] = 'Add School Details';
        $data['title_list'] = 'School Details';


		$this->form_validation->set_rules('name', 'School Name', 'required');
		$this->form_validation->set_rules('school_type', 'School Details', 'required');
		$this->form_validation->set_rules('school_group', 'School Group', 'required');
		$this->form_validation->set_rules('contact_person', 'School Contact Person', 'required');
		$this->form_validation->set_rules('contact_person_cell', 'School Contact Person Phone', 'required');
		$this->form_validation->set_rules('address', 'School Address', 'required');
		$this->form_validation->set_rules('email', 'School Email', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			

            $active = 1;
            $deprt_array = array(
				'date' => date('d-m-Y h:i:sa'),				
				'name' => $this->input->post('name'),					
				'school_type' => $this->input->post('school_type'),					
				'school_group' => $this->input->post('school_group'),					
				'contact_person' => $this->input->post('contact_person'),					
				'contact_person_cell' => $this->input->post('contact_person_cell'),					
				'address' => $this->input->post('address'),					
				'email' => $this->input->post('email'),					
				'active' => 1				
            );
			$this->school_details_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">School Details added successfully</div>');
            redirect('school_details');
        }  
         $data['school_details']=$this->school_details_model->select();  
         $data['school_type']=$this->school_type_model->select();  
         $data['school_group']=$this->school_group_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('school_details/school_detailsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'School Details';
        $this->school_details_model->remove($id);
        redirect('school_details');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'School Details');
        $this->session->set_userdata('sub_menu', 'school_details/index');
		
        $data['school_details']=$this->school_details_model->select(); 
	    $data['school_type']=$this->school_type_model->select();  
        $data['school_group']=$this->school_group_model->select();  
        $data['title'] = 'Edit School Details';
        $data['id'] = $id;

        $data['school_details'] = $this->school_details_model->update($id);
				
		$this->form_validation->set_rules('name', 'School Name', 'required');
		$this->form_validation->set_rules('school_type', 'School Details', 'required');
		$this->form_validation->set_rules('school_group', 'School Group', 'required');
		$this->form_validation->set_rules('contact_person', 'School Contact Person', 'required');
		$this->form_validation->set_rules('contact_person_cell', 'School Contact Person Phone', 'required');
		$this->form_validation->set_rules('address', 'School Address', 'required');
		$this->form_validation->set_rules('email', 'School Email', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('school_details/school_detailsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
				'id' => $id,				
				'name' => $this->input->post('name'),					
				'school_type' => $this->input->post('school_type'),					
				'school_group' => $this->input->post('school_group'),					
				'contact_person' => $this->input->post('contact_person'),					
				'contact_person_cell' => $this->input->post('contact_person_cell'),					
				'address' => $this->input->post('address'),					
				'email' => $this->input->post('email'),								
            );
            $this->school_details_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">School Details updated successfully</div>');
            redirect('school_details/index');
        }
    }

}

?>