<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payment_methods extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Payment Methods');
        $this->session->set_userdata('sub_menu', 'payment_methods/index');
        $data['title'] = 'Add Payment Methods';
        $data['title_list'] = 'Payment Methods';

		$this->form_validation->set_rules('payment_methods', 'Payment Methods', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $payment_methods = $this->input->post('payment_methods');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'payment_methods' => $this->input->post('payment_methods'),							
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->payment_methods_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Payment Methods added successfully</div>');
            redirect('payment_methods');
        }  
         $data['payment_methods']=$this->payment_methods_model->select();  
		 //$data['currency'] = $this->homecurrencies_model->select_currency();

        $this->load->view('layout/header', $data);
        $this->load->view('payment_methods/payment_methodsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Payment Methods';
        $this->payment_methods_model->remove($id);
        redirect('payment_methods');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Payment Methods');
        $this->session->set_userdata('sub_menu', 'payment_methods/index');
		
        $data['payment_methods']=$this->payment_methods_model->select(); 
        $data['title'] = 'Edit Payment Methods';
        $data['id'] = $id;

        $data['payment_methods'] = $this->payment_methods_model->update($id);
		//$data['currency'] = $this->homecurrencies_model->select_currency();
				
		$this->form_validation->set_rules('payment_methods', 'Payment Methods', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('payment_methods/payment_methodsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'payment_methods' => $this->input->post('payment_methods'),	
                'description' => $this->input->post('description'),
            );
            $this->payment_methods_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Payment Methods updated  successfully</div>');
            redirect('payment_methods/index');
        }
    }

}

?>