<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Medical_details extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Medical Details');
        $this->session->set_userdata('sub_menu', 'medical_details/index');
        $data['title'] = 'Add Medical Details';
        $data['title_list'] = 'Medical Details';

		$this->form_validation->set_rules('student_id', 'Medical Details', 'required');
		$this->form_validation->set_rules('doctor', 'Doctor Name', 'required');
		$this->form_validation->set_rules('allergy', 'Allergy', 'required');
		$this->form_validation->set_rules('period', 'Period with challenge', 'required');
		$this->form_validation->set_rules('status', 'Problem Status', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $medical_details = $this->input->post('medical_details');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'date_captured' => date('d-m-Y h:i:sa'),					
				'student_id' => $this->input->post('student_id'),				
				'doctor' => $this->input->post('doctor'),				
				'allergy' => $this->input->post('allergy'),				
				'period' => $this->input->post('period'),				
				'status' => $this->input->post('status'),				
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->medical_details_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Medical Details added successfully</div>');
            redirect('medical_details');
        }  
         $data['medical_details']=$this->medical_details_model->select();  
         $data['allergies']=$this->allergies_model->select();  
         $data['medical_practitioner']=$this->medical_model->select();  
         $data['stud_id']=$this->student_model->select();

        $this->load->view('layout/header', $data);
        $this->load->view('medical_details/medical_detailsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->departments_model->remove($id);
        redirect('medical_details');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Medical Details');
        $this->session->set_userdata('sub_menu', 'medical_details/index');
		
        $data['medical_details']=$this->medical_details_model->select(); 
        $data['title'] = 'Edit Medical Details';
        $data['id'] = $id;

        $data['medical_details'] = $this->medical_details_model->update($id);
		
		 $data['medical_details']=$this->medical_details_model->select();  
         $data['allergies']=$this->allergies_model->select();  
         $data['medical_practitioner']=$this->medical_model->select();  
         $data['stud_id']=$this->student_model->select();

				
		$this->form_validation->set_rules('student_id', 'Medical Details', 'required');
		$this->form_validation->set_rules('doctor', 'Doctor Name', 'required');
		$this->form_validation->set_rules('allergy', 'Allergy', 'required');
		$this->form_validation->set_rules('period', 'Period with challenge', 'required');
		$this->form_validation->set_rules('status', 'Problem Status', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('medical_details/medical_detailsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
				'student_id' => $this->input->post('student_id'),				
				'doctor' => $this->input->post('doctor'),				
				'allergy' => $this->input->post('allergy'),				
				'period' => $this->input->post('period'),				
				'status' => $this->input->post('status'),				
				'description' => $this->input->post('description'),		
            );
            $this->medical_details_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Medical Details updated  successfully</div>');
            redirect('medical_details/index');
        }
    }

}

?>