<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Medical extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Medical Practitioner');
        $this->session->set_userdata('sub_menu', 'medical/index');
        $data['title'] = 'Add Medical Practitioner';
        $data['title_list'] = 'Medical Practitioner';

		$this->form_validation->set_rules('name', 'Doctor Name', 'required');
		$this->form_validation->set_rules('address', 'Doctor Address', 'required');
		$this->form_validation->set_rules('phone', 'Doctor Phone', 'required');
		$this->form_validation->set_rules('email', 'Doctor Email', 'required');
		$this->form_validation->set_rules('company_name', 'Company Name', 'required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');

		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $active = 1;
            $deprt_array = array(
				'date_captured' => date('d-m-Y h:i:sa'),			
				'name' => $this->input->post('name'),				
				'address' => $this->input->post('address'),				
				'phone' => $this->input->post('phone'),				
				'email' => $this->input->post('email'),				
				'company_name' => $this->input->post('company_name'),				
				'description' => $this->input->post('description'),				
				'company_address' => $this->input->post('company_address'),				
				'active' => 1				
            );
			$this->medical_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Medical Practitioner added successfully</div>');
            redirect('medical');
        }  
         $data['medical']=$this->medical_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('medical/medicalList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Medical Practitioner';
        $this->departments_model->remove($id);
        redirect('medical');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Medical Practitioner');
        $this->session->set_userdata('sub_menu', 'medical/index');
		
        $data['medical']=$this->medical_model->select(); 
        $data['title'] = 'Edit Medical Practitioner';
        $data['id'] = $id;

        $data['medical'] = $this->medical_model->update($id);
		
		$this->form_validation->set_rules('name', 'Doctor Name', 'required');
		$this->form_validation->set_rules('address', 'Doctor Address', 'required');
		$this->form_validation->set_rules('phone', 'Doctor Phone', 'required');
		$this->form_validation->set_rules('email', 'Doctor Email', 'required');
		$this->form_validation->set_rules('company_name', 'Company Name', 'required');
		$this->form_validation->set_rules('company_address', 'Company Address', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('medical/medicalEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
				'name' => $this->input->post('name'),				
				'address' => $this->input->post('address'),				
				'phone' => $this->input->post('phone'),				
				'email' => $this->input->post('email'),				
				'company_name' => $this->input->post('company_name'),				
				'description' => $this->input->post('description'),				
				'company_address' => $this->input->post('company_address'),	
            );
            $this->medical_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Medical Practitioner updated  successfully</div>');
            redirect('medical/index');
        }
    }

}

?>