<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class MV_expenses extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
		
		 if (!$this->rbac->hasPrivilege('class', 'can_view')) {access_denied();}
		 
				$this->session->set_userdata('top_menu', 'MV Expenses History');
				$this->session->set_userdata('sub_menu', 'MV_expenses/index');

				$this->form_validation->set_rules('mv_expense', 'Vehicle', 'required');
				$this->form_validation->set_rules('from', 'Start Date', 'required');
				$this->form_validation->set_rules('to', 'End Date', 'required');

				if ($this->form_validation->run() == FALSE) {
					
									$data['vehicle_list']=$this->cashbook_model->select_vehicle(); 
									$data['glledger_accounts']=$this->glledger_accounts_model->select();

									$this->load->view('layout/header', $data);
									$this->load->view('mv_expense/mv_expense_history', $data);
									$this->load->view('layout/footer', $data);
					
				} else {			

						$mv_expense = $this->input->post('mv_expense');
						$from = $this->input->post('from');
						$to = $this->input->post('to');
						$search = $this->input->post('search');
												
					if (isset($search)) {
						
								$data['vehicle_list']=$this->cashbook_model->select_vehicle(); 
						
							if($mv_expense == 'All'){
								
									$resultlist = $this->supplier_model->mv_expense_history_TO_FROM($from, $to);
									$data['results'] = $resultlist;
										
										//$data['print'] = "ITS PRINTING IN if statement";
									$data['glledger_accounts']=$this->glledger_accounts_model->select();
									
									$this->load->view('layout/header', $data);
									$this->load->view('mv_expense/mv_expense_history', $data);
									$this->load->view('layout/footer', $data);
							}							
							else{
									$resultlist = $this->supplier_model->mv_expense_history_search($mv_expense, $from, $to);
									$data['results'] = $resultlist;
										
									$data['glledger_accounts']=$this->glledger_accounts_model->select();
									
									//$data['print'] = "ITS PRINTING IN else statement";
									
									$this->load->view('layout/header', $data);
									$this->load->view('mv_expense/mv_expense_history', $data);
									$this->load->view('layout/footer', $data);
							}


					}
					else{
						  echo "PLEASE NOTHING HAS BEEN SUBMITTED TO  FORM";
					}
				}          
    }    
 function mv_expense_report() {
		
		 if (!$this->rbac->hasPrivilege('class', 'can_view')) {access_denied();}
		 
				$this->session->set_userdata('top_menu', 'MV Expenses Report');
				$this->session->set_userdata('sub_menu', 'MV_expenses/mv_expense_report');

				$this->form_validation->set_rules('mv_expense', '', 'required');
				$this->form_validation->set_rules('from', 'Start Date', 'required');
				$this->form_validation->set_rules('to', 'End Date', 'required');

				if ($this->form_validation->run() == FALSE) {
					
									//$data['income_report']=$this->supplier_model->select(); 
									$data['vehicle_list']=$this->cashbook_model->select_vehicle(); 
									$data['glledger_accounts']=$this->glledger_accounts_model->select();

									$this->load->view('layout/header', $data);
									$this->load->view('mv_expense/mv_expense_report', $data);
									$this->load->view('layout/footer', $data);
					
				} else {			

						$mv_expense = $this->input->post('mv_expense');
						$from = $this->input->post('from');
						$to = $this->input->post('to');
						$search = $this->input->post('search');
												
					if (isset($search)) {
						
								$data['vehicle_list']=$this->cashbook_model->select_vehicle(); 
						
							if($gl_account == 'All'){
								
									$resultlist = $this->supplier_model->mv_expense_report_TO_FROM($from, $to);
									$data['results'] = $resultlist;
										
										//$data['print'] = "ITS PRINTING IN if statement";
									$data['glledger_accounts']=$this->glledger_accounts_model->select();
									$data['mv_expense'] = $mv_expense;
									$data['from'] = $from;
									$data['to'] = $to;										
									$this->load->view('layout/header', $data);
									$this->load->view('mv_expense/mv_expense_report', $data);
									$this->load->view('layout/footer', $data);
							}							
							else{
									$resultlist = $this->supplier_model->mv_expense_report_search($gl_account, $from, $to);
									$data['results'] = $resultlist;
										
									$data['glledger_accounts']=$this->glledger_accounts_model->select();
									
									//$data['print'] = "ITS PRINTING IN else statement";
									$data['mv_expense'] = $mv_expense;
									$data['from'] = $from;
									$data['to'] = $to;										
									$this->load->view('layout/header', $data);
									$this->load->view('mv_expense/mv_expense_report', $data);
									$this->load->view('layout/footer', $data);
							}


					}
					else{
						  echo "PLEASE NOTHING HAS BEEN SUBMITTED TO  FORM";
					}
				}          
    }  
	function printMv_expenseReport() {
		
		 if (!$this->rbac->hasPrivilege('class', 'can_view')) {access_denied();}	
		        $setting_result = $this->setting_model->get();
                $data['settinglist'] = $setting_result;
				
						$mv_expense = $this->input->post('mv_expense');
						$from = $this->input->post('from');
						$to = $this->input->post('to');

								$data['vehicle_list']=$this->cashbook_model->select_vehicle(); 
						
							if($gl_account == 'All'){
								
									$resultlist = $this->supplier_model->mv_expense_report_TO_FROM($from, $to);
									$data['results'] = $resultlist;
										
										//$data['print'] = "ITS PRINTING IN if statement";
									$data['glledger_accounts']=$this->glledger_accounts_model->select();
									$data['mv_expense'] = $mv_expense;
									$data['from'] = $from;
									$data['to'] = $to;									
                                    $this->load->view('print/printMv_expenseReport', $data);
							}							
							else{
									$resultlist = $this->supplier_model->mv_expense_report_search($gl_account, $from, $to);
									$data['results'] = $resultlist;
										
									$data['glledger_accounts']=$this->glledger_accounts_model->select();
									
									//$data['print'] = "ITS PRINTING IN else statement";
									$data['mv_expense'] = $mv_expense;
									$data['from'] = $from;
									$data['to'] = $to;										
                                    $this->load->view('print/printMv_expenseReport', $data);
							}     
    }    

    function printSupplierReceipt() {
	  
        $id = $this->input->post('id');

        $setting_result = $this->setting_model->get();
        $data['settinglist'] = $setting_result;
		
		$this->db->select('*');
		$this->db->from('supplier_receipt');
		$this->db->where('id = ', $id);
		$query = $this->db->get();
        $data['supplierReceipt'] = $query;
        $data['supID'] = $id;


        $this->load->view('print/printSupplierReceipt', $data);

    }
   
   function printSupplierInvoice() {
	  
        $id = $this->input->post('id');

        $setting_result = $this->setting_model->get();
        $data['settinglist'] = $setting_result;
		
		$this->db->select('*');
		$this->db->from('supplier_invoice');
		$this->db->where('id = ', $id);
		$query = $this->db->get();
        $data['supplierInvoice'] = $query;
        $data['supID'] = $id;


        $this->load->view('print/printSupplierInvoice', $data);

    }

}

?>