<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Location extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Employee');
        $this->session->set_userdata('sub_menu', 'location/index');
        $data['title'] = 'Add Employee';
        $data['title_list'] = 'Employee';

		$this->form_validation->set_rules('location', 'Employee', 'required');
		$this->form_validation->set_rules('department', 'Department', 'required');
		$this->form_validation->set_rules('designation', 'Designation', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $location = $this->input->post('location');
            $department = $this->input->post('department');
            $designation = $this->input->post('designation');
            $description = $this->input->post('description');
            $active = 1;
            $location_array = array(
				'location' => $this->input->post('location'),				
				'department' => $this->input->post('department'),				
				'designation' => $this->input->post('designation'),				
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			
			$this->location_model->add($location_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Employee added successfully</div>');
            redirect('location');
        }  
         $data['location']=$this->location_model->select();  
         $data['department']=$this->departments_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('location/locationList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Employee';
        $this->location_model->remove($id);
        redirect('location');
    }

    function edit($id) {
        $this->session->set_userdata('top_menu', 'Employee');
        $this->session->set_userdata('sub_menu', 'location/index');
		
        $data['location']=$this->location_model->select(); 
        $data['title'] = 'Edit Employee';
        $data['id'] = $id;

		$data['department']=$this->departments_model->select();  

        $data['location'] = $this->location_model->update($id);
				
		$this->form_validation->set_rules('location', 'Employee', 'required');
		$this->form_validation->set_rules('department', 'Department', 'required');
		$this->form_validation->set_rules('designation', 'Designation', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('location/locationEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $location = $this->input->post('location');
            $department = $this->input->post('department');
            $designation = $this->input->post('designation');
            $description = $this->input->post('description');
            $active = 1;
            $data = array(
				'location' => $this->input->post('location'),				
				'department' => $this->input->post('department'),				
				'designation' => $this->input->post('designation'),				
				'description' => $this->input->post('description'),				
				'active' => 1
            );
            $this->location_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Employee updated  successfully</div>');
            redirect('location/index');
        }
    }

}

?>