<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Journal_accounts extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Journal Accounts');
        $this->session->set_userdata('sub_menu', 'journal_accounts/index');
        $data['title'] = 'Add Journal Accounts';
        $data['title_list'] = 'Journal Accounts';

		$this->form_validation->set_rules('journal_accounts', 'Journal Accounts', 'required');
		$this->form_validation->set_rules('currency', 'Currency', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $journal_accounts = $this->input->post('journal_accounts');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'journal_accounts' => $this->input->post('journal_accounts'),		
				'currency' => $this->input->post('currency'),					
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->journal_accounts_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Journal Accounts added successfully</div>');
            redirect('journal_accounts');
        }  
           $data['journal_accounts']=$this->journal_accounts_model->select(); 
            $data['currency']=$this->currencies_model->select();		 
		 //$data['currency'] = $this->homecurrencies_model->select_currency();

        $this->load->view('layout/header', $data);
        $this->load->view('journal_accounts/journal_accountsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->journal_accounts_model->remove($id);
        redirect('journal_accounts');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Journal Accounts');
        $this->session->set_userdata('sub_menu', 'journal_accounts/index');
		
        $data['journal_accounts']=$this->journal_accounts_model->select(); 
        $data['title'] = 'Edit Journal Accounts';
        $data['id'] = $id;

        $data['journal_accounts'] = $this->journal_accounts_model->update($id);
		$data['currency'] = $this->homecurrencies_model->select_currency();
				
		$this->form_validation->set_rules('journal_accounts', 'Journal Accounts', 'required');
			$this->form_validation->set_rules('currency', 'Currency', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('journal_accounts/journal_accountsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'journal_accounts' => $this->input->post('journal_accounts'),
				'currency' => $this->input->post('currency'),	
                'description' => $this->input->post('description'),
            );
            $this->journal_accounts_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Journal Accounts updated  successfully</div>');
            redirect('journal_accounts/index');
        }
    }

}

?>