<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Jornal extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Journal');
        $this->session->set_userdata('sub_menu', 'jornal/index');
        $data['title'] = 'Journal Processing';
        $data['title_list'] = 'Journal';

		$this->form_validation->set_rules('date', 'Date', 'required');
		$this->form_validation->set_rules('cashbook', 'Cashbook', 'required');
		$this->form_validation->set_rules('receipt', 'Receipt', 'required');
		$this->form_validation->set_rules('account', 'Account Name', 'required');
		$this->form_validation->set_rules('module', 'Module Name', 'required');

		$this->form_validation->set_rules('dr_cr', 'Transaction Code', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');


        if ($this->form_validation->run() == FALSE) {
            
        }  else {
				//CODE FOR GETTING THE HOME AND FOREIGN CURRENCY
				$this->db->select('*');
				$this->db->from('bank_rates');
				$query1 = $this->db->get();
				$result1 = $query1->row();

				$home_currency = $result1->home_currency;
				$foreign_currency = $result1->foreign_currency;
				
				//GETTING THE CURRENCY CODE
				$cashbook = $this->input->post('cashbook');
				$this->db->select('*');
				$this->db->from('journal_accounts');
				$this->db->where('journal_accounts',$cashbook);
				$query_currency = $this->db->get();
				$row_currency = $query_currency->row();
				$currency = $row_currency->currency;
				
			  $dr_cr = $this->input->post('dr_cr');
			  
			if($dr_cr == "dr"){
				
			$active = 1;
            $credit = 0.00;
            
			$debit = $this->input->post('amount');
			
			$balance = $debit - $credit;
			
			//CODE FOR CHECKING THE CURRENCY TO CONVERT TO
             if($currency=='USD'){
										
						$this->db->select('*');
						$this->db->from('bank_rates');
						$this->db->where('home_currency',$currency);
						$query1 = $this->db->get();
						$row1_rate = $query1->row();
						
						$home_rate = $row1_rate->home_rate;
						
						$converted_amt = $home_rate*$debit;				
					
					$cash_array = array(
					
						'date_captured' => date('d-m-Y h:i:sa'),				
						'date' => $this->input->post('date'),					
						'cashbook' => $this->input->post('cashbook'),					
						'description' => $this->input->post('description'),					
						'account' => $this->input->post('account'),		
						'module' => $this->input->post('module'),					
						'receipt' => $this->input->post('receipt'),							
						'debit' => $converted_amt,				
						'credit' => $credit,				
						'balance' =>  $balance,				
						'active' => $active				
					);
					$this->jornal_model->add($cash_array);
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Journal added successfully</div>');
					redirect('jornal');
			    }else{
					    
						$this->db->select('*');
						$this->db->from('bank_rates');
						$this->db->where('foreign_currency',$currency);
						$query1 = $this->db->get();
						$row1_rate2 = $query1->row();
						
						$foreign_currency_row1 = $row1_rate2->foreign_currency;
						$foreign_rate = $row1_rate2->foreign_rate;
						
						$converted_amt = ($debit/$foreign_rate)*1;	

						$cash_array = array(
						
							'date_captured' => date('d-m-Y h:i:sa'),				
							'date' => $this->input->post('date'),					
							'cashbook' => $this->input->post('cashbook'),					
							'description' => $this->input->post('description'),					
							'account' => $this->input->post('account'),		
							'module' => $this->input->post('module'),					
							'receipt' => $this->input->post('receipt'),							
							'debit' => $converted_amt,				
							'credit' => $credit,				
							'balance' =>  $balance,				
							'active' => $active				
						);
						$this->jornal_model->add($cash_array);
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Journal added successfully</div>');
						redirect('jornal');						

				}
			}
			else{
				
			$active = 1;
            $debit = 0.00;
			$credit = $this->input->post('amount');
			
			$balance = $debit - $credit;

			//CODE FOR CHECKING THE CURRENCY TO CONVERT TO
             if($currency=='USD'){
										
						$this->db->select('*');
						$this->db->from('bank_rates');
						$this->db->where('home_currency',$currency);
						$query1 = $this->db->get();
						$row1_rate = $query1->row();
						
						$home_rate = $row1_rate->home_rate;
						
						$converted_amt = $home_rate*$credit;				
					
					$cash_array = array(
					
						'date_captured' => date('d-m-Y h:i:sa'),				
						'date' => $this->input->post('date'),					
						'cashbook' => $this->input->post('cashbook'),					
						'description' => $this->input->post('description'),					
						'account' => $this->input->post('account'),		
						'module' => $this->input->post('module'),					
						'receipt' => $this->input->post('receipt'),							
						'debit' => $debit,				
						'credit' => $converted_amt,				
						'balance' =>  $balance,				
						'active' => $active				
					);
					$this->jornal_model->add($cash_array);
					$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Journal added successfully</div>');
					redirect('jornal');
			    }else{
					    
						$this->db->select('*');
						$this->db->from('bank_rates');
						$this->db->where('foreign_currency',$currency);
						$query1 = $this->db->get();
						$row1_rate2 = $query1->row();
						
						$foreign_currency_row1 = $row1_rate2->foreign_currency;
						$foreign_rate = $row1_rate2->foreign_rate;
						
						$converted_amt = ($credit/$foreign_rate)*1;	

						$cash_array = array(
						
							'date_captured' => date('d-m-Y h:i:sa'),				
							'date' => $this->input->post('date'),					
							'cashbook' => $this->input->post('cashbook'),					
							'description' => $this->input->post('description'),					
							'account' => $this->input->post('account'),		
							'module' => $this->input->post('module'),					
							'receipt' => $this->input->post('receipt'),							
							'debit' => $debit,				
							'credit' => $converted_amt,				
							'balance' =>  $balance,				
							'active' => $active				
						);
						$this->jornal_model->add($cash_array);
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Journal added successfully</div>');
						redirect('jornal');						

				}
			
			}

        } 

          $data['currency'] = $this->homecurrencies_model->select_currency();
         $data['journal_accounts']=$this->journal_accounts_model->select();  
         $data['jornal']=$this->jornal_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('journal/journalList', $data);
        $this->load->view('layout/footer', $data);
    }
	
	function getByModule() {
        $module = $this->input->get('class_id');
		
		if($module == 'Supplier'){
			$data = $this->cashbook_model->getSupplierByModule();
			echo json_encode($data);			
		}		
		elseif($module == 'Customer'){
			$data = $this->cashbook_model->getCustomerByModule();
			echo json_encode($data);			
		}		
		elseif($module == 'Learner'){
			$data = $this->cashbook_model->getLearnereByModule();
			echo json_encode($data);			
		}		
		elseif($module == 'GL'){
			$data = $this->cashbook_model->getGLByModule();
			echo json_encode($data);			
		}
		else{
			
          $data['currency'] = $this->homecurrencies_model->select_currency();
         $data['journal_accounts']=$this->journal_accounts_model->select();  
         $data['jornal']=$this->jornal_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('journal/journalList', $data);
        $this->load->view('layout/footer', $data);		
		}
        
    }

}

?>