<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Internationalcurrencies extends Admin_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('section', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'International Currencies');
        $this->session->set_userdata('sub_menu', 'internationalcurrencies/index');
        $data['title'] = 'International Currencies List';
		
        $this->form_validation->set_rules('currencycode', 'Currency Code', 'trim|required|xss_clean');
        $this->form_validation->set_rules('name', 'Currency Name', 'required');
        $this->form_validation->set_rules('description', 'Currency Description', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {

        } else {
			$active = 1;
            $currency_data = array(               
                'currencycode' => $this->input->post('currencycode'),
				'date' => date('Y-m-d'),
                'name' => $this->input->post('name'),
                'description' => $this->input->post('description'),
                'active' => $active
            );
			
            $this->currency_model->add($currency_data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Currency Code added successfully</div>');
            redirect('internationalcurrencies/index');		
        }
		 $data['currency']=$this->currencies_model->select();  
			$currency_result = $this->currency_model->select_currency();
            $data['currencylist'] = $currency_result;
		
		    $this->load->view('layout/header', $data);
            $this->load->view('internationalcurrencies/internationalcurrenciesList', $data);
             $this->load->view('layout/footer', $data);
    }

 

    function delete($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'International Currencies List';
        $this->currency_model->remove($id);
        redirect('internationalcurrencies/index');
    }
    
    function edit($id) {
        if (!$this->rbac->hasPrivilege('internationalcurrencies', 'can_edit')) {
            access_denied();
        }
        $data['title'] = 'International Currencies List';
        $data['title'] = 'Edit International Currencies';
        $data['id'] = $id;
		$data['currency']=$this->currencies_model->select(); 
		
		$data['currencylist'] = $this->currency_model->select_currency();
			
        $data['currency1'] = $this->currency_model->update($id);
		
        $this->form_validation->set_rules('currencycode', 'Currency Code', 'trim|required');
        $this->form_validation->set_rules('name', 'Currency Name', 'required');
        $this->form_validation->set_rules('description', 'Currency Description', 'trim|required|xss_clean');
		
        if ($this->form_validation->run() == FALSE) {
		    $this->load->view('layout/header', $data);
            $this->load->view('internationalcurrencies/internationalcurrenciesEdit', $data);
             $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'currencycode' => $this->input->post('currencycode'),
                'name' => $this->input->post('name'),
                'description' => $this->input->post('description')
            );
            $this->currency_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Foreign Currency updated successfully</div>');
            redirect('internationalcurrencies/index');
        }					
		
    }

}

?>