<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Homecurrencies extends Admin_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('section', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Home Currencies');
        $this->session->set_userdata('sub_menu', 'homecurrencies/index');
        $data['title'] = 'Home Currencies List';
		
        $this->form_validation->set_rules('currencycode', 'Currency Code', 'trim|required|xss_clean');
        $this->form_validation->set_rules('name', 'Currency Name', 'required');
        $this->form_validation->set_rules('description', 'Currency Description', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {

        } else {
			$active = 1;
            $currency_data = array(               
                'currencycode' => $this->input->post('currencycode'),
				'date' => date('d-m-Y h:i:sa'),
                'name' => $this->input->post('name'),
                'description' => $this->input->post('description'),
                'active' => $active,
            );
			
            $this->homecurrencies_model->add_currency($currency_data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Home Currency added successfully</div>');
            redirect('homecurrencies/index');		
        }
		   $data['currency']=$this->currencies_model->select();  
			$currency_result = $this->homecurrencies_model->select_currency();
            $data['homecurrencieslist'] = $currency_result;
		
		    $this->load->view('layout/header', $data);
            $this->load->view('homecurrencies/homecurrenciesList', $data);
             $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Home Currency List';
        $this->homecurrencies_model->remove($id);
        redirect('homecurrencies/index');
    }

    function edit($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_edit')) {
            access_denied();
        }
        $data['title'] = 'Home Currency  List';
        $data['title'] = 'Edit Home Currency ';
        $data['id'] = $id;
		
		 $data['currency']=$this->currencies_model->update();  
        $home = $this->homecurrencies_model->get($id);
		
        $data['home'] = $home;
		
        $this->form_validation->set_rules('currencycode', 'Currency Code', 'trim|required|xss_clean');
        $this->form_validation->set_rules('name', 'Currency Name', 'required');
        $this->form_validation->set_rules('description', 'Currency Description', 'trim|required|xss_clean');
		
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('homecurrencies/homecurrenciesEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'currencycode' => $this->input->post('currencycode'),
                'name' => $this->input->post('name'),
                'description' => $this->input->post('description')
            );
            $this->homecurrencies_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Home Currency updated successfully</div>');
            redirect('homecurrencies/index');
        }
    }

}

?>