<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Glsub_accounts extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'SUB Account');
        $this->session->set_userdata('sub_menu', 'glsub_accounts/index');
        $data['title'] = 'Add SUB Account';
        $data['title_list'] = 'SUB Account';

		$this->form_validation->set_rules('glsub_code', 'GL SUB Code', 'required');
		$this->form_validation->set_rules('name', 'GL Name', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('account_type', 'GL SUB Account Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
		
		
		// $gl_code = $this->input->post('account_type');
		 
            $active = 1;
            $deprt_array = array(
				'date' => date('Y-m-d h:i:sa'),	
				'glsub_code' => $this->input->post('glsub_code'),		
				'name' => $this->input->post('name'),					
				'description' => $this->input->post('description'),				
				'account_type' => $this->input->post('account_type'),				
				'active' => 1				
            );
			$this->glsub_accounts_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">GL SUB Account added successfully</div>');
            redirect('glsub_accounts');
        }  		
		
         $data['glsub_accounts']=$this->glsub_accounts_model->select();  
		 $data['glledger_accounts']=$this->glledger_accounts_model->select();
		// $data['gl_accounts_type']=$this->gl_accounts_types_model->select(); 

        $this->load->view('layout/header', $data);
        $this->load->view('glsub_accounts/glsub_accountsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->glsub_accounts_model->remove($id);
        redirect('glsub_accounts');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'SUB Account');
        $this->session->set_userdata('sub_menu', 'glsub_accounts/index');
		
        $data['glsub_accounts']=$this->glsub_accounts_model->select(); 
        $data['title'] = 'Edit SUB Account';
        $data['id'] = $id;

        $data['glsub_accounts'] = $this->glsub_accounts_model->update($id);
		 $data['glledger_accounts']=$this->glledger_accounts_model->select();
				
		$this->form_validation->set_rules('glsub_code', 'GL SUB Code', 'required');
		$this->form_validation->set_rules('name', 'GL Name', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('account_type', 'GL SUB Account Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('glsub_accounts/glsub_accountsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
				'glsub_code' => $this->input->post('glsub_code'),		
				'name' => $this->input->post('name'),					
				'description' => $this->input->post('description'),				
				'account_type' => $this->input->post('account_type'),
            );
            $this->glsub_accounts_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">GL SUB Account updated  successfully</div>');
            redirect('glsub_accounts/index');
        }
    }

}

?>