<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Glledger_accounts extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'General Ledger Account');
        $this->session->set_userdata('sub_menu', 'glledger_accounts/index');
        $data['title'] = 'Add General ledger Account';
        $data['title_list'] = 'General ledger Account';

		$this->form_validation->set_rules('gl_code', 'GL Code', 'required');
		$this->form_validation->set_rules('name', 'GL Name', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('account_type', 'GL Account Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
            $active = 1;
            $deprt_array = array(
				'date' => date('Y-m-d h:i:sa'),	
				'gl_code' => $this->input->post('gl_code'),		
				'name' => $this->input->post('name'),					
				'description' => $this->input->post('description'),				
				'account_type' => $this->input->post('account_type'),				
				'active' => 1				
            );
			$this->glledger_accounts_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">General ledger Account added successfully</div>');
            redirect('glledger_accounts');
        }  
		
         $data['glledger_accounts']=$this->glledger_accounts_model->select();  
		 $data['gl_accounts_type']=$this->gl_accounts_types_model->select(); 

        $this->load->view('layout/header', $data);
        $this->load->view('glledger_accounts/glledger_accountsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->glledger_accounts_model->remove($id);
        redirect('glledger_accounts');
    }

    function edit($id) {
        $this->session->set_userdata('top_menu', 'General ledger Account');
        $this->session->set_userdata('sub_menu', 'glledger_accounts/index');
		
        $data['glledger_accounts']=$this->glledger_accounts_model->select(); 
        $data['title'] = 'Edit General ledger Account';
        $data['id'] = $id;

        $data['glledger_accounts'] = $this->glledger_accounts_model->update($id);
		 $data['gl_accounts_type']=$this->gl_accounts_types_model->select(); 
				
		$this->form_validation->set_rules('gl_code', 'GL Code', 'required');
		$this->form_validation->set_rules('name', 'GL Name', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('account_type', 'GL Account Type', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('glledger_accounts/glledger_accountsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
				'gl_code' => $this->input->post('gl_code'),		
				'name' => $this->input->post('name'),					
				'description' => $this->input->post('description'),				
				'account_type' => $this->input->post('account_type'),
            );
            $this->glledger_accounts_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">General ledger Account updated  successfully</div>');
            redirect('glledger_accounts/index');
        }
    }
	    function printGLAccounts() {
	  
        $id = $this->input->post('id');

        $setting_result = $this->setting_model->get();
        $data['settinglist'] = $setting_result;
		$data['glledger_accounts']=$this->glledger_accounts_model->select();  
		$data['gl_accounts_type']=$this->gl_accounts_types_model->select();

        $this->load->view('print/printGLAccounts', $data);

    }

}

?>