<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gl_accounts_types extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Account Type');
        $this->session->set_userdata('sub_menu', 'gl_accounts_types/index');
        $data['title'] = 'Add Account Type';
        $data['title_list'] = 'Account Type';

		$this->form_validation->set_rules('name', 'Account Type', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $active = 1;
            $deprt_array = array(
				'name' => $this->input->post('name'),							
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->gl_accounts_types_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Account Type added successfully</div>');
            redirect('gl_accounts_types');
        }  
         $data['gl_accounts_types']=$this->gl_accounts_types_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('gl_accounts_types/gl_accounts_typesList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->gl_accounts_types_model->remove($id);
        redirect('gl_accounts_types');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Account Type');
        $this->session->set_userdata('sub_menu', 'gl_accounts_types/index');
		
        $data['gl_accounts_types']=$this->gl_accounts_types_model->select(); 
        $data['title'] = 'Edit Account Type';
        $data['id'] = $id;

        $data['gl_accounts_types'] = $this->gl_accounts_types_model->update($id);
				
		$this->form_validation->set_rules('name', 'Account Type', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('gl_accounts_types/gl_accounts_typesEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'name' => $this->input->post('name'),
                'description' => $this->input->post('description'),
            );
            $this->gl_accounts_types_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Account Type updated  successfully</div>');
            redirect('gl_accounts_types/index');
        }
    }

}

?>