<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Depreciationmethods extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Depreciation methods');
        $this->session->set_userdata('sub_menu', 'depreciationmethods/index');
        $data['title'] = 'Add Depreciationmethods';
        $data['title_list'] = 'Depreciationmethods';

		//$this->form_validation->set_rules('description', 'Description', 'required');
		//$this->form_validation->set_rules('percentage', 'Depreciation Percentage', 'required');
		//$this->form_validation->set_rules('no_of_years', 'Number of Years', 'required');
		//$this->form_validation->set_rules('total_units', 'Total Units', 'required');
		//$this->form_validation->set_rules('initial_percentage', 'Initial Percentage', 'required');
		$this->form_validation->set_rules('depreciation_basis', 'Depreciation Basis', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $percentage = $this->input->post('percentage');
            $no_of_years = $this->input->post('no_of_years');
            $total_units = $this->input->post('total_units');
            $initial_percentage = $this->input->post('initial_percentage');
            $depreciation_basis = $this->input->post('depreciation_basis');
            $description = $this->input->post('description');
            $active = 1;
            $depreciationmethods_array = array(
				'date_captured' => date('d-m-Y h:i:sa'),				
				'description' => $this->input->post('description'),				
				'percentage' => $this->input->post('percentage'),				
				'no_of_years' => $this->input->post('no_of_years'),				
				'total_units' => $this->input->post('total_units'),				
				'initial_percentage' => $this->input->post('initial_percentage'),				
				'depreciation_basis' => $this->input->post('depreciation_basis'),				
				'active' => 1				
            );
			
			$this->depreciationmethods_model->add($depreciationmethods_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Depreciation Methods added successfully</div>');
            redirect('depreciationmethods');
        }  
         $data['depreciation']=$this->depreciationmethods_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('depreciationmethods/depreciationmethodsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Depreciationmethods';
        $this->depreciationmethods_model->remove($id);
        redirect('depreciationmethods');
    }

    function edit($id) {
        $this->session->set_userdata('top_menu', 'Depreciationmethods');
        $this->session->set_userdata('sub_menu', 'depreciationmethods/index');
		
        $data['depreciation']=$this->depreciationmethods_model->select(); 
        $data['title'] = 'Edit Depreciationmethods';
        $data['id'] = $id;

        $data['depreciation'] = $this->depreciationmethods_model->update($id);
						
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('depreciationmethods/depreciationmethodsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
           $percentage = $this->input->post('percentage');
            $no_of_years = $this->input->post('no_of_years');
            $total_units = $this->input->post('total_units');
            $initial_percentage = $this->input->post('initial_percentage');
            $depreciation_basis = $this->input->post('depreciation_basis');
            $description = $this->input->post('description');
            $data = array(
				'description' => $this->input->post('description'),				
				'percentage' => $this->input->post('percentage'),				
				'no_of_years' => $this->input->post('no_of_years'),				
				'total_units' => $this->input->post('total_units'),				
				'initial_percentage' => $this->input->post('initial_percentage'),				
				'depreciation_basis' => $this->input->post('depreciation_basis')
            );
            $this->depreciationmethods_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Depreciation Methods updated  successfully</div>');
            redirect('depreciationmethods/index');
        }
    }

}

?>