<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Depreciationexpenses extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Depreciation Expenses');
        $this->session->set_userdata('sub_menu', 'depreciationexpenses/index');
        $data['title'] = 'Add Depreciation Expenses';
        $data['title_list'] = 'Depreciation Expenses';

		$this->form_validation->set_rules('depreciationexpenses', 'Depreciation Expenses', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $depreciationexpenses = $this->input->post('depreciationexpenses');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'depreciationexpenses' => $this->input->post('depreciationexpenses'),				
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->depreciationexpenses_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Depreciation Expenses added successfully</div>');
            redirect('depreciationexpenses');
        }  
         $data['depreciationexpenses']=$this->depreciationexpenses_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('depreciationexpenses/depreciationexpensesList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Depreciation Expenses';
        $this->depreciationexpenses_model->remove($id);
        redirect('depreciationexpenses');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Depreciation Expenses');
        $this->session->set_userdata('sub_menu', 'depreciationexpenses/index');
		
        $data['depart']=$this->depreciationexpenses_model->select(); 
        $data['title'] = 'Edit Depreciation Expenses';
        $data['id'] = $id;

        $data['depreciationexpenses'] = $this->depreciationexpenses_model->update($id);
				
		$this->form_validation->set_rules('depreciationexpenses', 'Depreciation Expenses', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('depreciationexpenses/depreciationexpensesEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'depreciationexpenses' => $this->input->post('depreciationexpenses'),
                'description' => $this->input->post('description'),
            );
            $this->depreciationexpenses_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Depreciation Expenses updated  successfully</div>');
            redirect('depreciationexpenses/index');
        }
    }

}

?>