<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Department extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Department');
        $this->session->set_userdata('sub_menu', 'department/index');
        $data['title'] = 'Add Department';
        $data['title_list'] = 'Department';

		$this->form_validation->set_rules('department', 'Department', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $department = $this->input->post('department');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'department' => $this->input->post('department'),				
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->departments_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Department added successfully</div>');
            redirect('department');
        }  
         $data['depart']=$this->departments_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('department/departmentList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Department';
        $this->departments_model->remove($id);
        redirect('department');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Department');
        $this->session->set_userdata('sub_menu', 'department/index');
		
        $data['depart']=$this->departments_model->select(); 
        $data['title'] = 'Edit Department';
        $data['id'] = $id;

        $data['department'] = $this->departments_model->update($id);
				
		$this->form_validation->set_rules('department', 'Department', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('department/departmentEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'department' => $this->input->post('department'),
                'description' => $this->input->post('description'),
            );
            $this->departments_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Department updated  successfully</div>');
            redirect('department/index');
        }
    }

}

?>