<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Dailyrates extends Admin_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('section', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Daily Rates');
        $this->session->set_userdata('sub_menu', 'dailyrates/index');
        $data['title'] = 'Daily Rates List';

        $this->form_validation->set_rules('foreign_currency', 'Foreign Currency', 'required');
        $this->form_validation->set_rules('home_currency', 'Home Currency', 'required');
        $this->form_validation->set_rules('foreign_rate', 'Foreign Rate', 'required');
        $this->form_validation->set_rules('home_rate', 'Home Rate', 'required');
        $this->form_validation->set_rules('description', 'Description', 'required');
        if ($this->form_validation->run() == FALSE) {
			

        } else {
			 $active = 1;
            $bankrate_data = array(
			     
				'date' => date('d-m-Y h:i:sa'),			
                'foreign_currency' => $this->input->post('foreign_currency'),
                'home_currency' => $this->input->post('home_currency'),
                'foreign_rate' => $this->input->post('foreign_rate'),
                'home_rate' => $this->input->post('home_rate'),
                'description' => $this->input->post('description'),
                'active' => $active,
            );
            $this->dailyrates_model->add_currency($bankrate_data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Daily Rate added successfully</div>');
            redirect('dailyrates/index');
        }
			$data['foreignc']=$this->currency_model->select_currency(); 		 
            $data['homec']=$this->homecurrencies_model->select_currency();  
            $data['dailyrates']=$this->dailyrates_model->select_currency();  
			
            $this->load->view('layout/header', $data);
            $this->load->view('dailyrates/dailyratesList', $data);
            $this->load->view('layout/footer', $data);
    }

    function historyrates() {
        if (!$this->rbac->hasPrivilege('section', 'can_view')) {
            access_denied();
        }

        $dailyrates = $this->dailyrates_model->select_currency();
        $data['dailyrates'] = $dailyrates;
        $this->load->view('layout/header', $data);
        $this->load->view('dailyrates/historyrates', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('section', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Daily Rates List';
        $this->dailyrates_model->remove($id);
        redirect('dailyrates/index');
    }

       function edit($id) {
        $this->session->set_userdata('top_menu', 'Daily Rates');
        $this->session->set_userdata('sub_menu', 'dailyrates/index');

        $data['title'] = 'Edit Daily Rates';
        $data['id'] = $id;

            $data['dailyrates'] = $this->dailyrates_model->update($id);
			$data['foreignc']=$this->currency_model->select_currency(); 		 
            $data['homec']=$this->homecurrencies_model->select_currency();   
           $data['dailyrateslist']=$this->dailyrates_model->select_currency(); 			
				
        $this->form_validation->set_rules('foreign_currency', 'Foreign Currency', 'required');
        $this->form_validation->set_rules('home_currency', 'Home Currency', 'required');
        $this->form_validation->set_rules('foreign_rate', 'Foreign Rate', 'required');
        $this->form_validation->set_rules('home_rate', 'Home Rate', 'required');
        $this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('dailyrates/dailyratesEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'foreign_currency' => $this->input->post('foreign_currency'),
                'home_currency' => $this->input->post('home_currency'),
                'foreign_rate' => $this->input->post('foreign_rate'),
                'home_rate' => $this->input->post('home_rate'),
                'description' => $this->input->post('description')
            );
            $this->dailyrates_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Daily Rates updated  successfully</div>');
            redirect('dailyrates/index');
        }
    }

}

?>