<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Currency extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Currency');
        $this->session->set_userdata('sub_menu', 'currency/index');
        $data['title'] = 'Add Currencies';
        $data['title_list'] = 'Currencies';

		$this->form_validation->set_rules('currency', 'Currency', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $currency = $this->input->post('currency');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'currency' => $this->input->post('currency'),							
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->currencies_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Currency added successfully</div>');
            redirect('currency');
        }  
         $data['currency']=$this->currencies_model->select();  
		 //$data['currency'] = $this->homecurrencies_model->select_currency();

        $this->load->view('layout/header', $data);
        $this->load->view('currency/currencyList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Currencies';
        $this->currencies_model->remove($id);
        redirect('currency');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Currencies');
        $this->session->set_userdata('sub_menu', 'currency/index');
		
        $data['currency']=$this->currencies_model->select(); 
        $data['title'] = 'Edit Currencies';
        $data['id'] = $id;

        $data['currency'] = $this->currencies_model->update($id);
		//$data['currency'] = $this->homecurrencies_model->select_currency();
				
		$this->form_validation->set_rules('currency', 'Currency', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('currency/currencyEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'currency' => $this->input->post('currency'),	
                'description' => $this->input->post('description'),
            );
            $this->currencies_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Currency updated  successfully</div>');
            redirect('currency/index');
        }
    }

}

?>