<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Categories extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Category');
        $this->session->set_userdata('sub_menu', 'categories/index');
        $data['title'] = 'Add Category';
        $data['title_list'] = 'Category';

		$this->form_validation->set_rules('sport', 'Sport Type', 'required');
		$this->form_validation->set_rules('age_group', 'Age Group', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');
		
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			

            $active = 1;
            $deprt_array = array(
				'sport' => $this->input->post('sport'),				
				'age_group' => $this->input->post('age_group'),				
				'gender' => $this->input->post('gender'),				
				'active' => 1				
            );
			$this->categories_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Categories added successfully</div>');
            redirect('categories');
        }  
         $data['categories']=$this->categories_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('categories/categoriesList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->departments_model->remove($id);
        redirect('categories');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Category');
        $this->session->set_userdata('sub_menu', 'categories/index');
		
        $data['categories']=$this->categories_model->select(); 
        $data['title'] = 'Edit Categories';
        $data['id'] = $id;

        $data['categories'] = $this->categories_model->update($id);
				
		$this->form_validation->set_rules('sport', 'Sport Type', 'required');
		$this->form_validation->set_rules('age_group', 'Age Group', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('categories/categoriesEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
				'sport' => $this->input->post('sport'),				
				'age_group' => $this->input->post('age_group'),				
				'gender' => $this->input->post('gender'),	
            );
            $this->categories_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Categories updated  successfully</div>');
            redirect('categories/index');
        }
    }

}

?>