<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cashbook_accounts extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Cashbook Accounts');
        $this->session->set_userdata('sub_menu', 'cashbook_accounts/index');
        $data['title'] = 'Add Cashbook Accounts';
        $data['title_list'] = 'Cashbook Accounts';

		$this->form_validation->set_rules('cashbook_accounts', 'Cashbook Accounts', 'required');
		$this->form_validation->set_rules('currency', 'Currency', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $cashbook_accounts = $this->input->post('cashbook_accounts');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'cashbook_accounts' => $this->input->post('cashbook_accounts'),		
				'currency' => $this->input->post('currency'),					
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->cashbook_accounts_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Cashbook Accounts added successfully</div>');
            redirect('cashbook_accounts');
        }  
         $data['cashbook_accounts']=$this->cashbook_accounts_model->select();  
		 $data['currency'] = $this->homecurrencies_model->select_currency();

        $this->load->view('layout/header', $data);
        $this->load->view('cashbook_accounts/cashbook_accountsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->cashbook_accounts_model->remove($id);
        redirect('cashbook_accounts');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Cashbook Accounts');
        $this->session->set_userdata('sub_menu', 'cashbook_accounts/index');
		
        $data['cashbook_accounts']=$this->cashbook_accounts_model->select(); 
        $data['title'] = 'Edit Cashbook Accounts';
        $data['id'] = $id;

        $data['cashbook_accounts'] = $this->cashbook_accounts_model->update($id);
		$data['currency'] = $this->homecurrencies_model->select_currency();
				
		$this->form_validation->set_rules('cashbook_accounts', 'Cashbook Accounts', 'required');
			$this->form_validation->set_rules('currency', 'Currency', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('cashbook_accounts/cashbook_accountsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'cashbook_accounts' => $this->input->post('cashbook_accounts'),
				'currency' => $this->input->post('currency'),	
                'description' => $this->input->post('description'),
            );
            $this->cashbook_accounts_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Cashbook Accounts updated  successfully</div>');
            redirect('cashbook_accounts/index');
        }
    }

}

?>