<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cashbook extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Cashbook');
        $this->session->set_userdata('sub_menu', 'cashbook/index');
        $data['title'] = 'Cashbook Processing';
        $data['title_list'] = 'Cashbook';

		$this->form_validation->set_rules('date', 'Date', 'required');
		$this->form_validation->set_rules('cashbook', 'Cashbook', 'required');
		$this->form_validation->set_rules('receipt', 'Receipt', 'required');
		$this->form_validation->set_rules('account', 'Account Name', 'required');
		$this->form_validation->set_rules('module', 'Module Name', 'required');

		$this->form_validation->set_rules('dr_cr', 'Transaction Code', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		//$this->form_validation->set_rules('gl_account', 'GL Account', 'required');

        if ($this->form_validation->run() == FALSE) {
            
        } else {			

			  $dr_cr = $this->input->post('dr_cr');
			  
			if($dr_cr == 1){
				
			$active = 1;
            $credit = 0.00;
            $bankrec = 0;
            $gl_account = 'null';
            
			$debit = $this->input->post('amount');

			$balance = $debit - $credit;
            $cash_array = array(
				'date_captured' => date('Y-m-d h:i:sa'),				
				'date' => $this->input->post('date'),					
				'cashbook' => $this->input->post('cashbook'),					
				'description' => $this->input->post('description'),					
				'account' => $this->input->post('account'),					
				'module' => $this->input->post('module'),					
				'receipt' => $this->input->post('receipt'),							
				'debit' => $debit,				
				'credit' => $credit,				
				'balance' =>  $balance,				
				'active' => $active,				
				'bankrec' => $bankrec,				
				'mv_expense' => $this->input->post('mv_expense'),				
				'gl_account' => $gl_account 				
            );
			
			$this->cashbook_model->add($cash_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Cashbook added successfully</div>');
            redirect('cashbook');
			}
			else{
				
			$active = 1;
            $debit = 0.00;
			$credit = $this->input->post('amount');
			
			$balance = 0.0;
			$bankrec = 0;
			
            $cash_array = array(
			
				'date_captured' => date('Y-m-d h:i:sa'),								
				'date' => $this->input->post('date'),					
				'cashbook' => $this->input->post('cashbook'),					
				'description' => $this->input->post('description'),					
				'account' => $this->input->post('account'),		
				'module' => $this->input->post('module'),					
				'receipt' => $this->input->post('receipt'),							
				'debit' => $debit,				
				'credit' => $credit,				
				'balance' =>  $balance,				
				'active' => $active,				
				'bankrec' => $bankrec,
				'mv_expense' => $this->input->post('mv_expense'),				
				'gl_account' => $this->input->post('gl_account')					
            );
			$this->cashbook_model->add($cash_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Cashbook added successfully</div>');
            redirect('cashbook');				
			}

        }  

          $data['currency'] = $this->homecurrencies_model->select_currency();
		  $data['glledger_accounts']=$this->glledger_accounts_model->select();
		  $data['vehicle_list']=$this->cashbook_model->select_vehicle();
         $data['cashbook']=$this->cashbook_model->select();  
         $data['cashbook_details']=$this->cashbook_accounts_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('cashbook/cashbookList', $data);
        $this->load->view('layout/footer', $data);
    }    
	
	function cashbook_report() {
		
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Cashbook Report');
        $this->session->set_userdata('sub_menu', 'cashbook_report/index');
        $data['title'] = 'Add Cashbook';
        $data['title_list'] = 'Cashbook';
		
         $data['cashbook']=$this->cashbook_model->select();   

        $this->load->view('layout/header', $data);
        $this->load->view('cashbook/cashbook_report', $data);
        $this->load->view('layout/footer', $data);
    }	
	
	function cashbooksearch() {
		
		 if (!$this->rbac->hasPrivilege('class', 'can_view')) {access_denied();}
		 
				$this->session->set_userdata('top_menu', 'Cashbook Report');
				$this->session->set_userdata('sub_menu', 'cashbook/cashbooksearch');

				$this->form_validation->set_rules('cashbook', 'Cashbook', 'required');
				$this->form_validation->set_rules('from', 'Start Date', 'required');
				$this->form_validation->set_rules('to', 'End Date', 'required');

				if ($this->form_validation->run() == FALSE) {
					
									 $data['cashbook']=$this->cashbook_accounts_model->select();   

									$this->load->view('layout/header', $data);
									$this->load->view('cashbook/cashbook_search', $data);
									$this->load->view('layout/footer', $data);
					
				} else {			

						$cashbook_account = $this->input->post('cashbook');
						$from = $this->input->post('from');
						$to = $this->input->post('to');
						$search = $this->input->post('search');
						
						
						
					if (isset($search)) {
						$data['selected_details'] = "".$from."".$to."".$cashbook_account;
							$resultlist = $this->cashbook_model->cashbook_search($cashbook_account, $from, $to);
							$data['cashresultlist'] = $resultlist;
						$data['cashbook_account'] = $cashbook_account;
						$data['from'] =$from;
						$data['to'] = $to;
							
						$this->load->view('layout/header', $data);
						$this->load->view('cashbook/cashbook_report', $data);
						$this->load->view('layout/footer', $data);
					}
					else{
						  echo "PLEASE NOTHING HAS BEEN SUBMITTED TO CASH BOOK FORM";
					}

				}  


    }
		
	function printCashbookReport() {
		
		 if (!$this->rbac->hasPrivilege('class', 'can_view')) {access_denied();}		

		        $setting_result = $this->setting_model->get();
                $data['settinglist'] = $setting_result;
				
						$cashbook_account = $this->input->post('cashbook_account');
						$from = $this->input->post('from');
						$to = $this->input->post('to');

						   // $data['selected_details'] = "".$from."".$to."".$cashbook_account;
							$resultlist = $this->cashbook_model->cashbook_search($cashbook_account, $from, $to);
							$data['cashresultlist'] = $resultlist;
						$data['cashbook_account'] = $cashbook_account;
						$data['from'] =$from;
						$data['to'] = $to;
                        $this->load->view('print/printCashbookReport', $data);

    }
	
	function getByModule() {
        $module = $this->input->get('class_id');
		
		if($module == 'Supplier'){
			$data = $this->cashbook_model->getSupplierByModule();
			echo json_encode($data);			
		}		
		elseif($module == 'Customer'){
			$data = $this->cashbook_model->getCustomerByModule();
			echo json_encode($data);			
		}		
		elseif($module == 'Learner'){
			$data = $this->cashbook_model->getLearnereByModule();
			echo json_encode($data);			
		}		
		elseif($module == 'GL'){
			$data = $this->cashbook_model->getGLByModule();
			echo json_encode($data);			
		}
		else{
			
			$data['cashbook']=$this->cashbook_accounts_model->select();
			 
			$this->load->view('layout/header', $data);
			$this->load->view('cashbook/cashbookList', $data);
			$this->load->view('layout/footer', $data);			
		}
        
    }

}

?>