<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Book_depreciation extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function calculate($id){
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Book Depreciation');
        $this->session->set_userdata('sub_menu', 'book_depreciation/calculate');
        $data['title'] = 'Calculate Book Depreciation';
        $data['title_list'] = 'Book Depreciation';
		$data['id'] = $id;
		$this->form_validation->set_rules('startdate', 'Start Date', 'required');
		$this->form_validation->set_rules('dpmethod', 'Depreciation Method', 'required');
		$this->form_validation->set_rules('residual_vale', 'Residual value', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {
					$this->db->select('*');
					$this->db->from('assets');
					$this->db->where('id', $id);
					$query1 = $this->db->get();
					$row = $query1->row();	
		 
					$asset = $row->asset_code;
					$purchasedate = $row->purchase_date;
					$purchasevalue = $row->purchase_price;
		
			$nbv = 0;
            $active = 1;
            $total = 0;
            $prioryears = 0;
            $currentyear = 0;
            $currentperiod = 0;
            $initial_allowance = 0;
            $impairements = 0;
            $startdate = $this->input->post('startdate');
            $residual_vale = $this->input->post('residual_vale');
			
			$date1 = date("Y-m-d",strtotime($purchasedate));
			$date2 = date("Y-m-d",strtotime($startdate));

			$diff = abs(strtotime($date2) - strtotime($date1));
			$days = $diff/60/60/24;
            
			$amount = ($purchasevalue - $residual_vale) / $days;
			
			$currentperiod = $amount / 30;

			$currentyear =  $currentperiod * 12;
			
			$prioryears = $currentyear;
			
			$total = $amount;
			
			$nbv = $purchasevalue - ($currentyear * ($days/365));

            $deprt_array = array(
				'date_captured' => date('Y-m-d h:i:sa'),			
				'assetcode' => $asset,			
				'purchasevalue' => $purchasevalue,					
				'purchasedate' => $purchasedate,					
				'startdate' => $startdate,				
				'dpmethod' => $this->input->post('dpmethod'),				
				'total' => $total,				
				'prioryears' => $prioryears,				
				'currentyear' => $currentyear,				
				'currentperiod' => $currentperiod,				
				'initial_allowance' => $initial_allowance,				
				'residual_vale' => $residual_vale,				
				'impairements' => $impairements,				
				'nbv' => $nbv,				
				'active' => $active				
            );
			$this->book_depreciation_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Book Depreciation added successfully</div>');
            redirect('book_depreciation/calculate');
        }  
         $data['book_depreciation']=$this->book_depreciation_model->select();  
		 $data['dpmethods'] = $this->depreciationmethods_model->select();

        $this->load->view('layout/header', $data);
        $this->load->view('book_depreciation/book_depreciationList', $data);
        $this->load->view('layout/footer', $data);
    }

}

?>