<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bankreconciliation extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'bankreconciliation');
        $this->session->set_userdata('sub_menu', 'bankreconciliation/index');
        $data['title'] = 'Bank Reconciliation Statement';
        $data['title_list'] = 'Bank Reconciliation';

		
		$this->form_validation->set_rules('account', 'Account Name', 'required');
		$this->form_validation->set_rules('period', 'Period', 'required');
		$this->form_validation->set_rules('year', 'Year', 'required');
				//$this->form_validation->set_rules('find', 'Find', 'required');
		//$this->form_validation->set_rules('findby', 'Find By', 'required');
		//$this->form_validation->set_rules('stamntbal', 'Statement Balance', 'required');

        $data['year']=$this->bankrec_model->select_bankrec_yrperiod();

        if ($this->form_validation->run() == FALSE) {

			     $data['cashresultlist']=$this->cashbook_model->select_where_not_cleared();     
				 $data['cashbook_details']=$this->cashbook_accounts_model->select();  

				$this->load->view('layout/header', $data);
				$this->load->view('bankreconciliation/clearbank', $data);
				$this->load->view('layout/footer', $data); 
            
        } else {			

						$period = $this->input->post('period');
						$find = $this->input->post('find');
						$findby = $this->input->post('findby');
						$cashbook_account = $this->input->post('account');
						$period = $this->input->post('period');
						$stamntbal = $this->input->post('stamntbal');
						$year = $this->input->post('year');	
						$search = $this->input->post('search');	
					 												
				if (isset($search)) {

								 $data['period1']=$period;     
								 $data['year1']=$year;     
								 $data['cashbook_account1']=$cashbook_account; 						
								 $data['stamntbal1']=$stamntbal;
					
					if($findby == "all"){

								$resultlist = $this->bankrec_model->bankrec_search_all($cashbook_account, $period,$year);
								$data['cashresultlist1'] = $resultlist;
    
								 $data['cashbook']=$this->cashbook_model->select();     
								 $data['cashbook_details']=$this->cashbook_accounts_model->select(); 
							 
				 
								$this->load->view('layout/header', $data);
								$this->load->view('bankreconciliation/clearbank', $data);
								$this->load->view('layout/footer', $data);
						
					}						
					elseif($findby == "reference"){

									$resultlist = $this->bankrec_model->bankrec_search_by_reference($cashbook_account, $period, $year, $find);
									$data['cashresultlist1'] = $resultlist;
									
								 $data['cashbook']=$this->cashbook_model->select();     
								 $data['cashbook_details']=$this->cashbook_accounts_model->select(); 
				 
								$this->load->view('layout/header', $data);
								$this->load->view('bankreconciliation/clearbank', $data);
								$this->load->view('layout/footer', $data);
						
					}					
					elseif($findby == "payments"){

									$resultlist = $this->bankrec_model->bankrec_search_by_payments($cashbook_account, $period, $year, $find);
									$data['cashresultlist1'] = $resultlist;

								 $data['cashbook']=$this->cashbook_model->select();     
								 $data['cashbook_details']=$this->cashbook_accounts_model->select(); 
								 
								$this->load->view('layout/header', $data);
								$this->load->view('bankreconciliation/clearbank', $data);
								$this->load->view('layout/footer', $data);
						
					}										
					elseif($findby == "deposits"){
						
									$resultlist = $this->bankrec_model->bankrec_search_by_deposits($cashbook_account, $period, $year, $find);
									$data['cashresultlist1'] = $resultlist;

								 $data['cashbook']=$this->cashbook_model->select();     
								 $data['cashbook_details']=$this->cashbook_accounts_model->select(); 
				 
								$this->load->view('layout/header', $data);
								$this->load->view('bankreconciliation/clearbank', $data);
								$this->load->view('layout/footer', $data);
						
					}elseif($findby == "date"){
                                    
									$resultlist = $this->bankrec_model->bankrec_search_bydate($cashbook_account, $find);
									$data['cashresultlist1'] = $resultlist;

								 $data['cashbook']=$this->cashbook_model->select();     
								 $data['cashbook_details']=$this->cashbook_accounts_model->select(); 
								 
								$this->load->view('layout/header', $data);
								$this->load->view('bankreconciliation/clearbank', $data);
								$this->load->view('layout/footer', $data);						
					}
					else{
							 $data['cashresultlist']=$this->cashbook_model->select_where_not_cleared();     
							 $data['cashbook_details']=$this->cashbook_accounts_model->select();  

							$this->load->view('layout/header', $data);
							$this->load->view('bankreconciliation/clearbank', $data);
							$this->load->view('layout/footer', $data); 	
					}
				}

        }  
        
    }    
	
	function clear_record() {
		
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'bankreconciliation');
        $this->session->set_userdata('sub_menu', 'bankreconciliation/clear_record');
        $data['title'] = 'Bank Reconciliation Statement';
        $data['title_list'] = 'Bank Reconciliation';
		
		$id = $this->input->post('cashbook_id');
		$period = $this->input->post('period');
		$statement_balance = $this->input->post('stamntbal');
		$cashbook_account = $this->input->post('cashbook_account');
		$year = $this->input->post('year');

				$this->db->select('*');
				$this->db->from('cashbook');
				$this->db->where('id',$id);
				$query1 = $this->db->get();
				$row1_rate2 = $query1->row();	
				$currency = $row1_rate2->cashbook; //E.G CBZ-ZWL
				$debit = $row1_rate2->debit; 				
				$credit = $row1_rate2->credit; 				
							
				// SELECTING TOTAL SUM OF DEBIT WITTH CURRENCY TYPE
				$bankrec = 0;
				$this->db->select_sum('debit');
				$this->db->from('cashbook');
				$this->db->where('cashbook', $currency);
				$this->db->where('bankrec', $bankrec);
				$query = $this->db->get();
				$result = $query->row();
				$total_deposits = $result->debit;									

				// SELECTING TOTAL SUM OF CREDIT WITTH CURRENCY TYPE
				$this->db->select_sum('credit');
				$this->db->from('cashbook');
				$this->db->where('cashbook', $currency);
				$this->db->where('bankrec', $bankrec);
				$query7 = $this->db->get();
				$result7 = $query7->row();
				$total_payments = $result7->credit;	
				
				$difference = $statement_balance - $debit;
				$computer_bank_bal = $total_payments - $total_deposits;
				
						$active = 1;
						$cbb_cr = 0.0;
						$rbb_cr = 0.0;
						$diff_dr = 0.0;
						
						$array = array(
							'date_captured' => date('Y-m-d h:i:sa'),		
							'cbb_dr' => $computer_bank_bal,					
							'cbb_cr' => $cbb_cr,				
							'tu_dr' => $total_deposits,				
							'tu_cr' => $total_payments,				
							'rbb_dr' => $computer_bank_bal,				
							'rbb_cr' => $rbb_cr,								
							'diff_cr' => $difference,								
							'diff_dr' => $diff_dr,								
							'active' => 1,				
							'cashbook_id' => $id,				
							'cashbook' => $currency				
						);						
						$cashbook_array = array(
							'id' => $id,										
							'bankrec' => 1				
						);
						
						$this->bankrec_model->update_cashbook_table($cashbook_array);
						$this->bankrec_model->add($array);
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Statement reconciled successfully</div>');
						redirect('bankreconciliation/index');	
				
				if($debit == "0"){
					
				}				
				elseif(!($debit == "0")){
					
					$difference = $statement_balance - $debit;
					
					if($total_payments < $total_deposits and $difference < 0){

						$active = 1;
						$cbb_cr = 0.0;
						$rbb_cr = 0.0;
						$diff_dr = 0.0;
						
						$array = array(
							'date_captured' => date('Y-m-d h:i:sa'),		
							'cbb_dr' => $computer_bank_bal,					
							'cbb_cr' => $cbb_cr,				
							'tu_dr' => $total_deposits,				
							'tu_cr' => $total_payments,				
							'rbb_dr' => $computer_bank_bal,				
							'rbb_cr' => $rbb_cr,								
							'diff_cr' => $difference,								
							'diff_dr' => $diff_dr,								
							'active' => 1,
							'cashbook_id' => $id,
							'cashbook' => $currency
						);
						$cashbook_array = array(
							'id' => $id,										
							'bankrec' => 1				
						);
						
						$this->bankrec_model->update_cashbook_table($cashbook_array);						
						$this->bankrec_model->add($array);
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Statement reconciled successfully</div>');
						redirect('bankreconciliation/index');					
					}
					elseif($total_payments < $total_deposits and $difference > 0){

						$active = 1;
						$cbb_cr = 0.0;
						$rbb_cr = 0.0;
						$diff_dr = 0.0;
						
						$array = array(
							'date_captured' => date('Y-m-d h:i:sa'),		
							'cbb_dr' => $computer_bank_bal,					
							'cbb_cr' => $cbb_cr,				
							'tu_dr' => $total_deposits,				
							'tu_cr' => $total_payments,				
							'rbb_dr' => $computer_bank_bal,				
							'rbb_cr' => $rbb_cr,							
							'diff_cr' => $diff_cr,								
							'diff_dr' => $difference,								
							'active' => 1,
							'cashbook_id' => $id,
							'cashbook' => $currency
						);
						$cashbook_array = array(
							'id' => $id,										
							'bankrec' => 1				
						);
						
						$this->bankrec_model->update_cashbook_table($cashbook_array);						
						$this->bankrec_model->add($array);
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Statement reconciled successfully</div>');
						redirect('bankreconciliation/index');						
						
					}					
				}				
				elseif($credit == "0"){

				}				
				elseif(!($credit == "0")){ //IF STATEMENT THAT WILL BE EXECUTED IF THERE IS A PAYMENT WHICH WAS MADE IN THE CASHBOOK
					
					$difference = $statement_balance - $credit;
					
					if($total_payments > $total_deposits and $difference < 0){

						$active = 1;
						$cbb_dr = 0.0;
						$rbb_dr = 0.0;
						$diff_dr = 0.0;
						
						$array = array(
							'date_captured' => date('Y-m-d h:i:sa'),		
							'cbb_dr' => $cbb_dr,					
							'cbb_cr' => $computer_bank_bal,				
							'tu_dr' => $total_deposits,				
							'tu_cr' => $total_payments,				
							'rbb_dr' => $rbb_dr,				
							'rbb_cr' => $computer_bank_bal,								
							'diff_cr' => $difference,								
							'diff_dr' => $diff_dr,								
							'active' => 1,
							'cashbook_id' => $id,
							'cashbook' => $currency
						);
						$cashbook_array = array(
							'id' => $id,										
							'bankrec' => 1				
						);
						
						$this->bankrec_model->update_cashbook_table($cashbook_array);						
						$this->bankrec_model->add($array);
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Statement reconciled successfully</div>');
						redirect('bankreconciliation/index');					
					}
					elseif($total_payments > $total_deposits and $difference > 0){

						$active = 1;
						$cbb_dr = 0.0;
						$rbb_dr = 0.0;
						$diff_cr = 0.0;
						
						$array = array(
							'date_captured' => date('Y-m-d h:i:sa'),		
							'cbb_dr' => $cbb_dr,					
							'cbb_cr' => $computer_bank_bal,				
							'tu_dr' => $total_deposits,				
							'tu_cr' => $total_payments,				
							'rbb_dr' => $rbb_dr,				
							'rbb_cr' => $computer_bank_bal,								
							'diff_cr' => $diff_cr,								
							'diff_dr' => $difference,								
							'active' => 1,
							'cashbook_id' => $id,
							'cashbook' => $currency
						);
						$cashbook_array = array(
							'id' => $id,										
							'bankrec' => 1				
						);
						
						$this->bankrec_model->update_cashbook_table($cashbook_array);						
						$this->bankrec_model->add($array);
						$this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Statement reconciled successfully</div>');
						redirect('bankreconciliation/index');											
					}					
				}
				else{
					$this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Statement did not reconcile correclty due to network connections
					, please retry.</div>');
					redirect('bankreconciliation/index');							
				}
    }	
	
	function bankrec_report() {
		
		 if (!$this->rbac->hasPrivilege('class', 'can_view')) {access_denied();}
		 
				$this->session->set_userdata('top_menu', 'bankreconciliation Report');
				$this->session->set_userdata('sub_menu', 'bankreconciliation/bankrec_report');
				$data['title'] = 'Add Bank Reconciliation';
				$data['title_list'] = 'Bank Reconciliation';

				$this->form_validation->set_rules('cashbook', 'Cashbook', 'required');
				//$this->form_validation->set_rules('from', 'Start Date', 'required');
				//$this->form_validation->set_rules('to', 'End Date', 'required');

				if ($this->form_validation->run() == FALSE) {
					
								$data['cashbook']=$this->cashbook_accounts_model->select();   

								$this->load->view('layout/header', $data);
								$this->load->view('bankreconciliation/bankrec_report', $data);
								$this->load->view('layout/footer', $data);
					
				} else {			

						$cashbook_account = $this->input->post('cashbook');
						//$from = $this->input->post('from');
						//$to = $this->input->post('to');
						$search = $this->input->post('search');												
						
					if (isset($search)) {
						   // $data['selected_details'] = "".$from."".$to."".$cashbook_account;
							$data['cashbook']=$this->cashbook_accounts_model->select();   
						    $data['bankreconciliation']=$this->bankrec_model->select_where_cleared($cashbook_account);
							$data['cashbook_account'] = $cashbook_account;
							$this->load->view('layout/header', $data);
							$this->load->view('bankreconciliation/bankrec_report', $data);
							$this->load->view('layout/footer', $data);
					}
					else{
						  echo "PLEASE NOTHING HAS BEEN SUBMITTED TO CASH BOOK FORM";
					}

				}  


    }	
	
	function printBankrecReport() {
		
		 if (!$this->rbac->hasPrivilege('class', 'can_view')) {access_denied();}
		        $setting_result = $this->setting_model->get();
                $data['settinglist'] = $setting_result;
				
						$cashbook_account = $this->input->post('cashbook_account');

						    $data['cashbook_account'] = $cashbook_account;
							$data['cashbook']=$this->cashbook_accounts_model->select();   
						    $data['bankreconciliation']=$this->bankrec_model->select_where_cleared($cashbook_account);
							
							$this->load->view('print/printBankrecReport', $data);


    }

	
	
	function cashbook_cleared() {
		
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
		
        $this->session->set_userdata('top_menu', 'bankreconciliation Report');
        $this->session->set_userdata('sub_menu', 'bankreconciliation/cashbook_cleared');
        $data['title'] = 'Add Bank Reconciliation';
        $data['title_list'] = 'Bank Reconciliation';
		
		$data['cashresultlist1']=$this->cashbook_model->select_where_cleared();     
		$data['cashbook_details']=$this->cashbook_accounts_model->select(); 

        $this->load->view('layout/header', $data);
        $this->load->view('bankreconciliation/cashbook_cleared', $data);
        $this->load->view('layout/footer', $data);
    }	
	
    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Add Bank Reconciliation';
		
			$this->bankrec_model->remove($id);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Statement has been unreconciled successfully</div>');		        
			redirect('bankreconciliation/bankrec_report');
    }    
	
	function cashbook_cleared_remove($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Add Bank Reconciliation';
		
			$cbdata = array(
                'id' => $id,
				'bankrec' => 0
            );
            $this->bankrec_model->update_cashbook_table($cbdata);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Statement has been unreconciled successfully</div>');		        
			redirect('bankreconciliation/cashbook_cleared');
    }



    function bankrec_yrperiod() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Bank Reconciliation Periods');
        $this->session->set_userdata('sub_menu', 'bankreconciliation/bankrec_yrperiod');
        $data['title'] = 'Add Bank Reconciliation Period';
        $data['title_list'] = 'Bank Reconciliation Period List';

		$this->form_validation->set_rules('year', 'Year', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $active = 1;
            $deprt_array = array(
				'year' => $this->input->post('year'),					
				'active' => 1				
            );
			$this->bankrec_model->add_bankrec_yrperiod($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Year added successfully</div>');
            redirect('bankreconciliation/bankrec_yrperiod');
        }   
		 $data['bankrec_yrperiod'] = $this->bankrec_model->select_bankrec_yrperiod();

        $this->load->view('layout/header', $data);
        $this->load->view('bankreconciliation/bankyearsList', $data);
        $this->load->view('layout/footer', $data);
    }

    function bankrec_yrperiod_delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        //$data['title'] = 'Cashbook_details';
        $this->bankrec_model->remove($id);
        redirect('bankreconciliation/bankrec_yrperiod');
    }


    function bankrec_yrperiod_edit($id) {
        $this->session->set_userdata('top_menu', 'Bank Reconciliation Periods');
        $this->session->set_userdata('sub_menu', 'bankreconciliation/bankrec_yrperiod_edit');
		
        $data['bankrec_yrperiod']=$this->bankrec_model->select_bankrec_yrperiod(); 
        $data['title'] = 'Edit Bank Reconciliation Period';
        $data['id'] = $id;

        $data['bankrec_yrperiod1'] = $this->bankrec_model->update_bankrec_yrperiod($id);
				
		$this->form_validation->set_rules('year', 'Year', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('bankreconciliation/bankyearsEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'year' => $this->input->post('year')
            );
            $this->bankrec_model->add_bankrec_yrperiod($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Year updated  successfully</div>');
            redirect('bankreconciliation/bankrec_yrperiod');
        }
    }


}

?>