<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Assettypes extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', ' Asset Types');
        $this->session->set_userdata('sub_menu', 'assettypes/index');
        $data['title'] = 'Add  Asset Type';
        $data['title_list'] = ' Asset Types';

		$this->form_validation->set_rules('asset_code', 'Asset Code', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('accum_dep', 'Accummulated Depreciation', 'required');
		$this->form_validation->set_rules('dep_expenses', 'Depreciation Expenses', 'required');
		$this->form_validation->set_rules('revaluation', 'Revaluation', 'required');
		$this->form_validation->set_rules('insurance', 'Insurance', 'required');
		$this->form_validation->set_rules('tax_dep', 'Tax Depreciation', 'required');
		$this->form_validation->set_rules('book_dep', 'Book Depreciation', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {				
            $active = 1;
            $asset_type_array = array(
				'date_captured' => date('d-m-Y h:i:sa'),				
				'asset_code' => $this->input->post('asset_code'),				
				'description' => $this->input->post('description'),				
				'accum_dep' => $this->input->post('accum_dep'),				
				'dep_expenses' => $this->input->post('dep_expenses'),				
				'revaluation' => $this->input->post('revaluation'),				
				'insurance' => $this->input->post('insurance'),				
				'tax_dep' => $this->input->post('tax_dep'),				
				'book_dep' => $this->input->post('book_dep'),				
				'active' => 1				
            );
			
			$this->assettypes_model->add($asset_type_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Asset Type added successfully</div>');
            redirect('assettypes');
        }  
	     $data['glledger_accounts']=$this->glledger_accounts_model->select();
         $data['asset_type']=$this->assettypes_model->select();  
         $data['depreciationexpenses']=$this->depreciationexpenses_model->select();   
         $data['accummdeprec']=$this->accummdeprec_model->select(); 
		 $data['depreciation']=$this->depreciationmethods_model->select(); 

        $this->load->view('layout/header', $data);
        $this->load->view('assettypes/assettypesList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = ' Asset Types';
        $this->assettypes_model->remove($id);
        redirect('assettypes');
    }

    function edit($id) {
        $this->session->set_userdata('top_menu', ' Asset Types');
        $this->session->set_userdata('sub_menu', 'assettypes/index');
		
        $data['asset_type']=$this->assettypes_model->select(); 
        $data['title'] = 'Edit Asset Types';
        $data['id'] = $id;

        $data['asset_type'] = $this->assettypes_model->update($id);
		$data['glledger_accounts']=$this->glledger_accounts_model->select();
		$data['depreciationexpenses']=$this->depreciationexpenses_model->select();   
        $data['accummdeprec']=$this->accummdeprec_model->select(); 
		  $data['depreciation']=$this->depreciationmethods_model->select(); 
		
		$this->form_validation->set_rules('asset_code', 'Asset Code', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('accum_dep', 'Accummulated Depreciation', 'required');
		$this->form_validation->set_rules('dep_expenses', 'Depreciation Expenses', 'required');
		$this->form_validation->set_rules('revaluation', 'Revaluation', 'required');
		$this->form_validation->set_rules('insurance', 'Insurance', 'required');
		$this->form_validation->set_rules('tax_dep', 'Tax Depreciation', 'required');
		$this->form_validation->set_rules('book_dep', 'Book Depreciation', 'required');
						
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('assettypes/assettypesEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
				'id' => $id,
				'asset_code' => $this->input->post('asset_code'),				
				'description' => $this->input->post('description'),				
				'accum_dep' => $this->input->post('accum_dep'),				
				'dep_expenses' => $this->input->post('dep_expenses'),				
				'revaluation' => $this->input->post('revaluation'),				
				'insurance' => $this->input->post('insurance'),				
				'tax_dep' => $this->input->post('tax_dep'),				
				'book_dep' => $this->input->post('book_dep')
            );
            $this->assettypes_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Asset Type updated  successfully</div>');
            redirect('assettypes/index');
        }
    }

}

?>