<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Asset extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', ' Assets');
        $this->session->set_userdata('sub_menu', 'asset/index');
        $data['title'] = 'Add  Asset';
        $data['title_list'] = ' Assets';

		$this->form_validation->set_rules('asset_code', 'Asset Code', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('asset_type', 'Asset Type', 'required');
		$this->form_validation->set_rules('master_asset', 'Master Asset', 'required');
		$this->form_validation->set_rules('units_num', 'Number of Units', 'required');
		//$this->form_validation->set_rules('serial_num', 'Serial Number', 'required');
		$this->form_validation->set_rules('department', 'Asset Department', 'required');
		$this->form_validation->set_rules('employee', 'Employee', 'required');
		//$this->form_validation->set_rules('supplier', 'Supplier', 'required');
		//$this->form_validation->set_rules('capex_order', 'Capex Number', 'required');
		$this->form_validation->set_rules('purchase_price', 'Purchase Price', 'required');
		//$this->form_validation->set_rules('insured_value', 'Insured Value', 'required');
		//$this->form_validation->set_rules('scrap_value', 'Scrap Value', 'required');
		///$this->form_validation->set_rules('revaluation', 'Revaluation', 'required');
		$this->form_validation->set_rules('purchase_date', 'Purchase Date', 'required');
		//$this->form_validation->set_rules('replacement_date', 'Replacement Date', 'required');
		//$this->form_validation->set_rules('replacement_cost', 'Replacement Cost', 'required');
		//$this->form_validation->set_rules('base_cost', 'Base Cost', 'required');
		//$this->form_validation->set_rules('roll_over_relief', 'Roll Over Relief', 'required');
	
        if ($this->form_validation->run() == FALSE) {
            
        } else {				
            $active = 1;
            $asset_array = array(
				'date_captured' => date('d-m-Y h:i:sa'),				
				'asset_code' => $this->input->post('asset_code'),				
				'description' => $this->input->post('description'),				
				'asset_type' => $this->input->post('asset_type'),				
				'master_asset' => $this->input->post('master_asset'),				
				'units_num' => $this->input->post('units_num'),				
				'serial_num' => $this->input->post('serial_num'),							
				'department' => $this->input->post('department'),				
				'employee' => $this->input->post('employee'),				
				'supplier' => $this->input->post('supplier'),				
				'capex_order' => $this->input->post('capex_order'),				
				'purchase_price' => $this->input->post('purchase_price'),				
				'insured_value' => $this->input->post('insured_value'),				
				'revaluation' => $this->input->post('revaluation'),				
				'purchase_date' => $this->input->post('purchase_date'),				
				'replacement_date' => $this->input->post('replacement_date'),				
				'replacement_cost' => $this->input->post('replacement_cost'),				
				'base_cost' => $this->input->post('base_cost'),				
				'roll_over_relief' => $this->input->post('roll_over_relief'),							
				'active' => 1				
            );
			
			$this->asset_model->add($asset_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Asset added successfully</div>');
            redirect('asset/index');
        }  
         $data['asset_type']=$this->assettypes_model->select();  
         $data['department']=$this->departments_model->select();  
         $data['employee']=$this->location_model->select();  
         $data['asset']=$this->asset_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('asset/assetList', $data);
        $this->load->view('layout/footer', $data);
    }    
	
	function viewasset() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', ' Assets');
        $this->session->set_userdata('sub_menu', 'asset/viewasset');
        $data['title'] = 'View  Asset List';
        $data['title_list'] = ' Assets';

         $data['asset_type']=$this->assettypes_model->select();  
         $data['department']=$this->departments_model->select();  
         $data['employee']=$this->location_model->select();  
         $data['asset']=$this->asset_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('asset/viewasset', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = ' Assets';
        $this->asset_model->remove($id);
        redirect('asset/viewasset');
    }

    function edit($id) {
        $this->session->set_userdata('top_menu', ' Assets');
        $this->session->set_userdata('sub_menu', 'asset/index');
		
        $data['asset']=$this->asset_model->select(); 
        $data['title'] = 'Edit Asset';
        $data['id'] = $id;

        $data['asset'] = $this->asset_model->update($id);
		
		$this->form_validation->set_rules('asset_code', 'Asset Code', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		$this->form_validation->set_rules('asset_type', 'Asset Type', 'required');
		$this->form_validation->set_rules('master_asset', 'Master Asset', 'required');
		$this->form_validation->set_rules('units_num', 'Number of Units', 'required');
		$this->form_validation->set_rules('serial_num', 'Serial Number', 'required');
		$this->form_validation->set_rules('department', 'Asset Department', 'required');
		$this->form_validation->set_rules('employee', 'Employee', 'required');
		$this->form_validation->set_rules('supplier', 'Supplier', 'required');
		$this->form_validation->set_rules('capex_order', 'Capex Number', 'required');
		$this->form_validation->set_rules('purchase_price', 'Purchase Price', 'required');
		$this->form_validation->set_rules('insured_value', 'Insured Value', 'required');
		$this->form_validation->set_rules('scrap_value', 'Scrap Value', 'required');
		$this->form_validation->set_rules('revaluation', 'Revaluation', 'required');
		$this->form_validation->set_rules('purchase_date', 'Purchase Date', 'required');
		$this->form_validation->set_rules('replacement_date', 'Replacement Date', 'required');
		$this->form_validation->set_rules('replacement_cost', 'Replacement Cost', 'required');
		$this->form_validation->set_rules('base_cost', 'Base Cost', 'required');
		$this->form_validation->set_rules('roll_over_relief', 'Roll Over Relief', 'required');
						
        if ($this->form_validation->run() == FALSE) {
			
			 $data['asset_type']=$this->assettypes_model->select();  
			 $data['department']=$this->departments_model->select();  
			 $data['employee']=$this->location_model->select();  
			 $data['asset']=$this->asset_model->select();  
			
            $this->load->view('layout/header', $data);
            $this->load->view('asset/assetEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
				'id' => $id,
				'asset_code' => $this->input->post('asset_code'),				
				'description' => $this->input->post('description'),				
				'asset_type' => $this->input->post('asset_type'),				
				'master_asset' => $this->input->post('master_asset'),				
				'units_num' => $this->input->post('units_num'),				
				'serial_num' => $this->input->post('serial_num'),							
				'department' => $this->input->post('department'),				
				'employee' => $this->input->post('employee'),				
				'supplier' => $this->input->post('supplier'),				
				'capex_order' => $this->input->post('capex_order'),				
				'purchase_price' => $this->input->post('purchase_price'),								
				'insured_value' => $this->input->post('insured_value'),		
				'scrap_value' => $this->input->post('scrap_value'),				
				'revaluation' => $this->input->post('revaluation'),				
				'purchase_date' => $this->input->post('purchase_date'),				
				'replacement_date' => $this->input->post('replacement_date'),				
				'replacement_cost' => $this->input->post('replacement_cost'),				
				'base_cost' => $this->input->post('base_cost'),				
				'roll_over_relief' => $this->input->post('roll_over_relief')
            );
            $this->asset_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Asset updated  successfully</div>');
            redirect('asset/viewasset');
        }
    }

}

?>