<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Allergies extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Allergies');
        $this->session->set_userdata('sub_menu', 'allergies/index');
        $data['title'] = 'Add Allergies';
        $data['title_list'] = 'Allergies';

		$this->form_validation->set_rules('allergies', 'Allergies', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $allergies = $this->input->post('allergies');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'allergies' => $this->input->post('allergies'),				
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->allergies_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Allergies added successfully</div>');
            redirect('allergies');
        }  
         $data['allergies']=$this->allergies_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('allergies/allergiesList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Cashbook_details';
        $this->departments_model->remove($id);
        redirect('allergies');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Allergies');
        $this->session->set_userdata('sub_menu', 'allergies/index');
		
        $data['allergies']=$this->allergies_model->select(); 
        $data['title'] = 'Edit Allergies';
        $data['id'] = $id;

        $data['allergies'] = $this->allergies_model->update($id);
				
		$this->form_validation->set_rules('allergies', 'Allergies', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('allergies/allergiesEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'allergies' => $this->input->post('allergies'),
                'description' => $this->input->post('description'),
            );
            $this->allergies_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Allergies updated  successfully</div>');
            redirect('allergies/index');
        }
    }

}

?>