<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Accummdeprec extends Admin_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->rbac->hasPrivilege('class', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Accummulated Depreciation');
        $this->session->set_userdata('sub_menu', 'accummdeprec/index');
        $data['title'] = 'Add Accummulated Depreciation';
        $data['title_list'] = 'Accummulated Depreciation';

		$this->form_validation->set_rules('accummdeprec', 'Accummulated Depreciation', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
            
        } else {			
			
            $accummdeprec = $this->input->post('accummdeprec');
            $description = $this->input->post('description');
            $active = 1;
            $deprt_array = array(
				'accummdeprec' => $this->input->post('accummdeprec'),				
				'description' => $this->input->post('description'),				
				'active' => 1				
            );
			$this->accummdeprec_model->add($deprt_array);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Accummulated Depreciation added successfully</div>');
            redirect('accummdeprec');
        }  
         $data['accummdeprec']=$this->accummdeprec_model->select();  

        $this->load->view('layout/header', $data);
        $this->load->view('accummdeprec/accummdeprecList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('class', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Accummulated Depreciation';
        $this->accummdeprec_model->remove($id);
        redirect('accummdeprec');
    }


    function edit($id) {
        $this->session->set_userdata('top_menu', 'Accummulated Depreciation');
        $this->session->set_userdata('sub_menu', 'accummdeprec/index');
		
        $data['depart']=$this->accummdeprec_model->select(); 
        $data['title'] = 'Edit Accummulated Depreciation';
        $data['id'] = $id;

        $data['accummdeprec'] = $this->accummdeprec_model->update($id);
				
		$this->form_validation->set_rules('accummdeprec', 'Accummulated Depreciation', 'required');
		$this->form_validation->set_rules('description', 'Description', 'required');
		
        if ($this->form_validation->run() == FALSE) {
			
            $this->load->view('layout/header', $data);
            $this->load->view('accummdeprec/accummdeprecEdit', $data);
            $this->load->view('layout/footer', $data);
			
        } else {
            $data = array(
                'id' => $id,
                'accummdeprec' => $this->input->post('accummdeprec'),
                'description' => $this->input->post('description'),
            );
            $this->accummdeprec_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">Accummulated Depreciation updated  successfully</div>');
            redirect('accummdeprec/index');
        }
    }

}

?>